/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.ui.webview.certbasedauth;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.ColorStateList;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;
import androidx.annotation.RequiresApi;
import androidx.appcompat.app.AlertDialog;
import com.microsoft.identity.common.R;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.SmartcardDialog;
import com.microsoft.identity.common.logging.Logger;
import lombok.NonNull;

public class SmartcardPinDialog
extends SmartcardDialog {
    private static final String TAG = SmartcardPinDialog.class.getSimpleName();
    private View mPinLayout;
    private final PositiveButtonListener mPositiveButtonListener;
    private final CancelCbaCallback mCancelCbaCallback;

    public SmartcardPinDialog(@NonNull PositiveButtonListener positiveButtonListener, @NonNull CancelCbaCallback cancelCbaCallback, @NonNull Activity activity) {
        super(activity);
        if (positiveButtonListener == null) {
            throw new NullPointerException("positiveButtonListener is marked non-null but is null");
        }
        if (cancelCbaCallback == null) {
            throw new NullPointerException("cancelCbaCallback is marked non-null but is null");
        }
        if (activity == null) {
            throw new NullPointerException("activity is marked non-null but is null");
        }
        this.mPositiveButtonListener = positiveButtonListener;
        this.mCancelCbaCallback = cancelCbaCallback;
        this.createDialog();
    }

    @Override
    protected void createDialog() {
        this.mActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                SmartcardPinDialog.this.mPinLayout = SmartcardPinDialog.this.mActivity.getLayoutInflater().inflate(R.layout.pin_textview_layout, null);
                AlertDialog.Builder builder = new AlertDialog.Builder((Context)SmartcardPinDialog.this.mActivity, R.style.CertAlertDialogTheme).setTitle(R.string.smartcard_pin_dialog_title).setMessage(R.string.smartcard_pin_dialog_message).setView(SmartcardPinDialog.this.mPinLayout).setPositiveButton(R.string.smartcard_pin_dialog_positive_button, null).setNegativeButton(R.string.smartcard_pin_dialog_negative_button, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        SmartcardPinDialog.this.mCancelCbaCallback.onCancel();
                    }
                });
                AlertDialog dialog = builder.create();
                dialog.setCanceledOnTouchOutside(false);
                dialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

                    public void onCancel(DialogInterface dialog) {
                        SmartcardPinDialog.this.mCancelCbaCallback.onCancel();
                    }
                });
                SmartcardPinDialog.this.mDialog = dialog;
            }
        });
    }

    @Override
    public void onCancelCba() {
        this.mCancelCbaCallback.onCancel();
    }

    @Override
    public void show() {
        final String methodTag = TAG + ":show";
        this.mActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                SmartcardPinDialog.this.mDialog.show();
                final EditText pinEditText = (EditText)SmartcardPinDialog.this.mPinLayout.findViewById(R.id.pinEditText);
                if (pinEditText == null) {
                    SmartcardPinDialog.this.mCancelCbaCallback.onCancel();
                    Logger.error(methodTag, "Error while retrieving dialog EditText component.", null);
                    return;
                }
                pinEditText.addTextChangedListener(new TextWatcher(){

                    @RequiresApi(api=21)
                    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                        if (start == 0) {
                            SmartcardPinDialog.this.resetErrorMode();
                        }
                    }

                    public void onTextChanged(CharSequence s, int start, int before, int count) {
                    }

                    public void afterTextChanged(Editable s) {
                    }
                });
                ((AlertDialog)SmartcardPinDialog.this.mDialog).getButton(-1).setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        char[] pin = new char[pinEditText.length()];
                        pinEditText.getText().getChars(0, pinEditText.length(), pin, 0);
                        SmartcardPinDialog.this.mPositiveButtonListener.onClick(pin);
                    }
                });
            }
        });
    }

    @RequiresApi(api=21)
    public void setErrorMode() {
        this.mActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                EditText pinEditText = (EditText)SmartcardPinDialog.this.mPinLayout.findViewById(R.id.pinEditText);
                pinEditText.getText().clear();
                pinEditText.setBackgroundTintList(ColorStateList.valueOf((int)SmartcardPinDialog.this.mActivity.getResources().getColor(R.color.dialogErrorText)));
                TextView errorTextView = (TextView)SmartcardPinDialog.this.mPinLayout.findViewById(R.id.errorTextView);
                errorTextView.setText(R.string.smartcard_pin_dialog_error_message);
            }
        });
    }

    @RequiresApi(api=21)
    public void resetErrorMode() {
        this.mActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                TextView errorTextView = (TextView)SmartcardPinDialog.this.mPinLayout.findViewById(R.id.errorTextView);
                errorTextView.setText((CharSequence)"");
                EditText pinEditText = (EditText)SmartcardPinDialog.this.mPinLayout.findViewById(R.id.pinEditText);
                pinEditText.setBackgroundTintList(ColorStateList.valueOf((int)SmartcardPinDialog.this.mActivity.getResources().getColor(R.color.dialogPinEditText)));
            }
        });
    }

    public static interface CancelCbaCallback {
        public void onCancel();
    }

    public static interface PositiveButtonListener {
        public void onClick(@NonNull char[] var1);
    }
}

