/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.ui.webview.certbasedauth;

import android.app.Activity;
import android.webkit.ClientCertRequest;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.AbstractNfcSmartcardCertBasedAuthManager;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.AbstractSmartcardCertBasedAuthChallengeHandler;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.AbstractSmartcardCertBasedAuthManager;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.ICertDetails;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.IConnectionCallback;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.IDialogHolder;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.ISmartcardSession;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.SmartcardNfcPromptDialog;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.SmartcardPinDialog;
import com.microsoft.identity.common.java.opentelemetry.ICertBasedAuthTelemetryHelper;

public class NfcSmartcardCertBasedAuthChallengeHandler
extends AbstractSmartcardCertBasedAuthChallengeHandler<AbstractNfcSmartcardCertBasedAuthManager> {
    public NfcSmartcardCertBasedAuthChallengeHandler(@NonNull Activity activity, @NonNull AbstractNfcSmartcardCertBasedAuthManager nfcSmartcardCertBasedAuthManager, @NonNull IDialogHolder dialogHolder, @NonNull ICertBasedAuthTelemetryHelper telemetryHelper) {
        super(activity, nfcSmartcardCertBasedAuthManager, dialogHolder, telemetryHelper, NfcSmartcardCertBasedAuthChallengeHandler.class.getSimpleName());
    }

    @Override
    protected void onPausedSmartcardDiscovery() {
        ((AbstractNfcSmartcardCertBasedAuthManager)this.mCbaManager).stopDiscovery(this.mActivity);
    }

    @Override
    protected SmartcardPinDialog.PositiveButtonListener getSmartcardPinDialogPositiveButtonListener(final @NonNull ICertDetails certDetails, final @NonNull ClientCertRequest request) {
        final String methodTag = this.TAG + ":getSmartcardPinDialogPositiveButtonListener";
        return new SmartcardPinDialog.PositiveButtonListener(){

            @Override
            @RequiresApi(api=21)
            public void onClick(final @NonNull char[] pin) {
                NfcSmartcardCertBasedAuthChallengeHandler.this.mDialogHolder.showSmartcardNfcPromptDialog(new SmartcardNfcPromptDialog.CancelCbaCallback(){

                    @Override
                    public void onCancel() {
                        NfcSmartcardCertBasedAuthChallengeHandler.this.mDialogHolder.dismissDialog();
                        NfcSmartcardCertBasedAuthChallengeHandler.this.mTelemetryHelper.setResultFailure("User canceled smartcard CBA flow.");
                        request.cancel();
                    }
                });
                ((AbstractNfcSmartcardCertBasedAuthManager)NfcSmartcardCertBasedAuthChallengeHandler.this.mCbaManager).setConnectionCallback(new IConnectionCallback(){

                    @Override
                    public void onCreateConnection() {
                        NfcSmartcardCertBasedAuthChallengeHandler.this.mDialogHolder.showSmartcardNfcLoadingDialog();
                        if (((AbstractNfcSmartcardCertBasedAuthManager)NfcSmartcardCertBasedAuthChallengeHandler.this.mCbaManager).isDeviceChanged()) {
                            NfcSmartcardCertBasedAuthChallengeHandler.this.indicateGeneralException(methodTag, new Exception("Device connected via NFC is different from initially connected device."));
                            request.cancel();
                            NfcSmartcardCertBasedAuthChallengeHandler.this.clearPin(pin);
                            NfcSmartcardCertBasedAuthChallengeHandler.this.onPausedSmartcardDiscovery();
                            return;
                        }
                        ((AbstractNfcSmartcardCertBasedAuthManager)NfcSmartcardCertBasedAuthChallengeHandler.this.mCbaManager).requestDeviceSession(new AbstractSmartcardCertBasedAuthManager.ISessionCallback(){

                            @Override
                            public void onGetSession(@NonNull ISmartcardSession session) throws Exception {
                                NfcSmartcardCertBasedAuthChallengeHandler.this.tryUsingSmartcardWithPin(pin, certDetails, request, session);
                                NfcSmartcardCertBasedAuthChallengeHandler.this.clearPin(pin);
                            }

                            @Override
                            public void onException(@NonNull Exception e) {
                                NfcSmartcardCertBasedAuthChallengeHandler.this.indicateGeneralException(methodTag, e);
                                request.cancel();
                                NfcSmartcardCertBasedAuthChallengeHandler.this.clearPin(pin);
                                NfcSmartcardCertBasedAuthChallengeHandler.this.onPausedSmartcardDiscovery();
                            }
                        });
                    }
                });
                ((AbstractNfcSmartcardCertBasedAuthManager)NfcSmartcardCertBasedAuthChallengeHandler.this.mCbaManager).startDiscovery(NfcSmartcardCertBasedAuthChallengeHandler.this.mActivity);
            }
        };
    }

    @Override
    @RequiresApi(api=21)
    protected void setPinDialogForIncorrectAttempt(@NonNull ICertDetails certDetails, final @NonNull ClientCertRequest request) {
        this.mDialogHolder.showPinDialog(this.getSmartcardPinDialogPositiveButtonListener(certDetails, request), new SmartcardPinDialog.CancelCbaCallback(){

            @Override
            @RequiresApi(api=21)
            public void onCancel() {
                NfcSmartcardCertBasedAuthChallengeHandler.this.mDialogHolder.dismissDialog();
                NfcSmartcardCertBasedAuthChallengeHandler.this.mTelemetryHelper.setResultFailure("User canceled smartcard CBA flow.");
                request.cancel();
            }
        });
        this.mDialogHolder.setPinDialogErrorMode();
    }
}

