/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.ui.webview;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Handler;
import android.webkit.ClientCertRequest;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import com.microsoft.identity.common.internal.broker.PackageHelper;
import com.microsoft.identity.common.internal.ui.webview.OAuth2WebViewClient;
import com.microsoft.identity.common.internal.ui.webview.OnPageLoadedCallback;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.CertBasedAuthFactory;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.ICertBasedAuthChallengeHandler;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.PKeyAuthChallengeHandler;
import com.microsoft.identity.common.java.challengehandlers.PKeyAuthChallenge;
import com.microsoft.identity.common.java.challengehandlers.PKeyAuthChallengeFactory;
import com.microsoft.identity.common.java.exception.BaseException;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.providers.RawAuthorizationResult;
import com.microsoft.identity.common.java.ui.webview.authorization.IAuthorizationCompletionCallback;
import com.microsoft.identity.common.java.util.StringUtil;
import com.microsoft.identity.common.logging.Logger;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Locale;

public class AzureActiveDirectoryWebViewClient
extends OAuth2WebViewClient {
    private static final String TAG = AzureActiveDirectoryWebViewClient.class.getSimpleName();
    public static final String ERROR = "error";
    public static final String ERROR_SUBCODE = "error_subcode";
    public static final String ERROR_DESCRIPTION = "error_description";
    private final String mRedirectUrl;
    private final CertBasedAuthFactory mCertBasedAuthFactory;
    private ICertBasedAuthChallengeHandler mCertBasedAuthChallengeHandler;

    public AzureActiveDirectoryWebViewClient(@NonNull Activity activity, @NonNull IAuthorizationCompletionCallback completionCallback, @NonNull OnPageLoadedCallback pageLoadedCallback, @NonNull String redirectUrl) {
        super(activity, completionCallback, pageLoadedCallback);
        this.mRedirectUrl = redirectUrl;
        this.mCertBasedAuthFactory = new CertBasedAuthFactory(activity);
    }

    public boolean shouldOverrideUrlLoading(WebView view, String url) {
        if (StringUtil.isNullOrEmpty((String)url)) {
            throw new IllegalArgumentException("Redirect to empty url in web view.");
        }
        return this.handleUrl(view, url);
    }

    @TargetApi(value=24)
    @RequiresApi(value=24)
    public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
        Uri requestUrl = request.getUrl();
        return this.handleUrl(view, requestUrl.toString());
    }

    private boolean handleUrl(WebView view, String url) {
        block12: {
            String methodTag = TAG + ":handleUrl";
            String formattedURL = url.toLowerCase(Locale.US);
            try {
                if (this.isPkeyAuthUrl(formattedURL)) {
                    Logger.info(methodTag, "WebView detected request for pkeyauth challenge.");
                    PKeyAuthChallengeFactory factory = new PKeyAuthChallengeFactory();
                    PKeyAuthChallenge pKeyAuthChallenge = factory.getPKeyAuthChallengeFromWebViewRedirect(url);
                    PKeyAuthChallengeHandler pKeyAuthChallengeHandler = new PKeyAuthChallengeHandler(view, this.getCompletionCallback());
                    pKeyAuthChallengeHandler.processChallenge(pKeyAuthChallenge);
                    break block12;
                }
                if (this.isRedirectUrl(formattedURL)) {
                    Logger.info(methodTag, "Navigation starts with the redirect uri.");
                    this.processRedirectUrl(view, url);
                    break block12;
                }
                if (this.isWebsiteRequestUrl(formattedURL)) {
                    Logger.info(methodTag, "It is an external website request");
                    this.processWebsiteRequest(view, url);
                    break block12;
                }
                if (this.isInstallRequestUrl(formattedURL)) {
                    Logger.info(methodTag, "It is an install request");
                    this.processInstallRequest(view, url);
                    break block12;
                }
                if (this.isWebCpUrl(formattedURL)) {
                    Logger.info(methodTag, "It is a request from WebCP");
                    this.processWebCpRequest(view, url);
                    break block12;
                }
                if (this.isPlayStoreUrl(formattedURL)) {
                    Logger.info(methodTag, "Request to open PlayStore.");
                    return this.processPlayStoreURL(view, url);
                }
                if (this.isAuthAppMFAUrl(formattedURL)) {
                    Logger.info(methodTag, "Request to link account with Authenticator.");
                    this.processAuthAppMFAUrl(url);
                    break block12;
                }
                if (this.isInvalidRedirectUri(url)) {
                    Logger.info(methodTag, "Check for Redirect Uri.");
                    this.processInvalidRedirectUri(view, url);
                    break block12;
                }
                if (this.isBlankPageRequest(formattedURL)) {
                    Logger.info(methodTag, "It is an blank page request");
                    break block12;
                }
                if (this.isUriSSLProtected(formattedURL)) {
                    Logger.info(methodTag, "Check for SSL protection");
                    this.processSSLProtectionCheck(view, url);
                    break block12;
                }
                Logger.info(methodTag, "This maybe a valid URI, but no special handling for this mentioned URI, hence deferring to WebView for loading.");
                this.processInvalidUrl(url);
                return false;
            }
            catch (ClientException exception) {
                Logger.error(methodTag, exception.getErrorCode(), null);
                Logger.errorPII(methodTag, exception.getMessage(), exception);
                this.returnError(exception.getErrorCode(), exception.getMessage());
                view.stopLoading();
            }
        }
        return true;
    }

    private boolean isUriSSLProtected(@NonNull String url) {
        return !url.startsWith("https://");
    }

    private boolean isBlankPageRequest(@NonNull String url) {
        return "about:blank".equals(url);
    }

    private boolean isInvalidRedirectUri(@NonNull String url) {
        return this.isBrokerRequest(this.getActivity().getIntent()) && url.startsWith("msauth");
    }

    private boolean isAuthAppMFAUrl(@NonNull String url) {
        return url.startsWith("microsoft-authenticator://activatemfa");
    }

    private boolean isPlayStoreUrl(@NonNull String url) {
        return url.startsWith("market://details?id=");
    }

    private boolean isPkeyAuthUrl(@NonNull String url) {
        return url.startsWith("urn:http-auth:PKeyAuth".toLowerCase(Locale.ROOT));
    }

    private boolean isRedirectUrl(@NonNull String url) {
        return url.startsWith(this.mRedirectUrl.toLowerCase(Locale.US));
    }

    private boolean isWebsiteRequestUrl(@NonNull String url) {
        return url.startsWith("browser://");
    }

    private boolean isInstallRequestUrl(@NonNull String url) {
        return url.startsWith("msauth://");
    }

    private boolean isBrokerRequest(Intent callingIntent) {
        return callingIntent != null && !StringExtensions.isNullOrBlank(callingIntent.getStringExtra("com.microsoft.aadbroker.adal.broker.request"));
    }

    private boolean isWebCpUrl(@NonNull String url) {
        return url.startsWith("companyportal://");
    }

    protected void processRedirectUrl(@NonNull WebView view, @NonNull String url) {
        String methodTag = TAG + ":processRedirectUrl";
        Logger.info(methodTag, "It is pointing to redirect. Final url can be processed to get the code or error.");
        RawAuthorizationResult data = RawAuthorizationResult.fromRedirectUri((String)url);
        this.getCompletionCallback().onChallengeResponseReceived(data);
        view.stopLoading();
    }

    private void processWebsiteRequest(@NonNull WebView view, @NonNull String url) {
        String methodTag = TAG + ":processWebsiteRequest";
        view.stopLoading();
        if (url.contains("&ismdmurl=1")) {
            Logger.info(methodTag, "This is a device CA request.");
            PackageHelper packageHelper = new PackageHelper(this.getActivity().getPackageManager());
            Context applicationContext = this.getActivity().getApplicationContext();
            if (packageHelper.isPackageInstalledAndEnabled(applicationContext, "com.microsoft.skype.teams.ipphone") && "fcg80qvoM1YMKJZibjBwQcDfOno=".equals(packageHelper.getCurrentSignatureForPackage("com.microsoft.skype.teams.ipphone")) && packageHelper.isPackageInstalledAndEnabled(applicationContext, "com.microsoft.windowsintune.companyportal")) {
                try {
                    this.launchCompanyPortal();
                    return;
                }
                catch (Exception ex) {
                    Logger.warn(methodTag, "Failed to launch Company Portal, falling back to browser.");
                }
            }
            this.openLinkInBrowser(url);
            this.returnResult(RawAuthorizationResult.ResultCode.MDM_FLOW);
            return;
        }
        this.openLinkInBrowser(url);
        this.returnResult(RawAuthorizationResult.ResultCode.CANCELLED);
    }

    private boolean processPlayStoreURL(@NonNull WebView view, @NonNull String url) {
        String methodTag = TAG + ":processPlayStoreURL";
        view.stopLoading();
        if (!url.startsWith("market://details?id=com.microsoft.windowsintune.companyportal") && !url.startsWith("market://details?id=com.azure.authenticator")) {
            Logger.info(methodTag, "The URI is either trying to open an unknown application or contains unknown query parameters");
            return false;
        }
        String appPackageName = url.contains("com.microsoft.windowsintune.companyportal") ? "com.microsoft.windowsintune.companyportal" : "com.azure.authenticator";
        Logger.info(methodTag, "Request to open PlayStore to install package : '" + appPackageName + "'");
        try {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)("market://details?id=" + appPackageName)));
            intent.addFlags(0x10008000);
            this.getActivity().startActivity(intent);
        }
        catch (ActivityNotFoundException e) {
            Logger.error(methodTag, "PlayStore is not present on the device", e);
        }
        return true;
    }

    private void processAuthAppMFAUrl(String url) {
        String methodTag = TAG + ":processAuthAppMFAUrl";
        Logger.verbose(methodTag, "Linking Account in Broker for MFA.");
        try {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
            intent.addFlags(0x10000000);
            this.getActivity().startActivity(intent);
        }
        catch (ActivityNotFoundException e) {
            Logger.error(methodTag, "Failed to open the Authenticator application.", e);
        }
    }

    private void launchCompanyPortal() {
        String methodTag = TAG + ":launchCompanyPortal";
        Logger.verbose(methodTag, "Sending intent to launch the CompanyPortal.");
        Intent intent = new Intent();
        intent.setComponent(new ComponentName("com.microsoft.windowsintune.companyportal", "com.microsoft.windowsintune.companyportal.views.SplashActivity"));
        intent.addFlags(0x10008000);
        this.getActivity().startActivity(intent);
        this.returnResult(RawAuthorizationResult.ResultCode.MDM_FLOW);
    }

    private void openLinkInBrowser(String url) {
        String methodTag = TAG + ":openLinkInBrowser";
        Logger.info(methodTag, "Try to open url link in browser");
        String link = url.replace("browser://", "https://");
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)link));
        if (intent.resolveActivity(this.getActivity().getPackageManager()) != null) {
            this.getActivity().startActivity(intent);
        } else {
            Logger.warn(methodTag, "Unable to find an app to resolve the activity.");
        }
    }

    private void processWebCpRequest(@NonNull WebView view, @NonNull String url) {
        view.stopLoading();
        if (url.equalsIgnoreCase("companyportal://enrollment")) {
            this.launchCompanyPortal();
            return;
        }
        this.returnError("webcp_uri_invalid", "Unexpected URL from WebCP: " + url);
    }

    private void processInstallRequest(final @NonNull WebView view, @NonNull String url) {
        String methodTag = TAG + ":processInstallRequest";
        RawAuthorizationResult result = RawAuthorizationResult.fromRedirectUri((String)url);
        if (result.getResultCode() != RawAuthorizationResult.ResultCode.BROKER_INSTALLATION_TRIGGERED) {
            this.getCompletionCallback().onChallengeResponseReceived(result);
            view.stopLoading();
            return;
        }
        HashMap<String, String> parameters = StringExtensions.getUrlParameters(url);
        final String appLink = (String)parameters.get("app_link");
        Logger.info(methodTag, "Launching the link to app:" + appLink);
        this.getCompletionCallback().onChallengeResponseReceived(result);
        Handler handler = new Handler();
        int threadSleepForCallingActivity = 1000;
        handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                String link = appLink.replace("browser://", "https://");
                Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)link));
                AzureActiveDirectoryWebViewClient.this.getActivity().startActivity(intent);
                view.stopLoading();
            }
        }, 1000L);
        view.stopLoading();
    }

    private void processInvalidRedirectUri(@NonNull WebView view, @NonNull String url) {
        String methodTag = TAG + ":processInvalidRedirectUri";
        Logger.error(methodTag, "The RedirectUri is not as expected.", null);
        Logger.errorPII(methodTag, String.format("Received %s and expected %s", url, this.mRedirectUrl), null);
        this.returnError("The redirectUri for broker is invalid", String.format("The RedirectUri is not as expected. Received %s and expected %s", url, this.mRedirectUrl));
        view.stopLoading();
    }

    private void processSSLProtectionCheck(@NonNull WebView view, @NonNull String url) {
        String methodTag = TAG + ":processSSLProtectionCheck";
        String redactedUrl = this.removeQueryParametersOrRedact(url);
        Logger.error(methodTag, "The webView was redirected to an unsafe URL: " + redactedUrl, null);
        this.returnError("Redirect url scheme not SSL protected", "The webView was redirected to an unsafe URL.");
        view.stopLoading();
    }

    private void processInvalidUrl(@NonNull String url) {
        String methodTag = TAG + ":processInvalidUrl";
        Logger.infoPII(methodTag, "We are declining to override loading and redirect to invalid URL: '" + this.removeQueryParametersOrRedact(url) + "' the user's url pattern is '" + this.mRedirectUrl + "'");
    }

    private String removeQueryParametersOrRedact(@NonNull String url) {
        String methodTag = TAG + ":removeQueryParametersOrRedact";
        try {
            return StringExtensions.removeQueryParameterFromUrl(url);
        }
        catch (URISyntaxException e) {
            Logger.errorPII(methodTag, "Redirect URI has invalid syntax, unable to parse", e);
            return "redacted";
        }
    }

    private void returnResult(RawAuthorizationResult.ResultCode resultCode) {
        this.getCompletionCallback().onChallengeResponseReceived(RawAuthorizationResult.fromResultCode((RawAuthorizationResult.ResultCode)resultCode));
    }

    private void returnError(String errorCode, String errorMessage) {
        this.getCompletionCallback().onChallengeResponseReceived(RawAuthorizationResult.fromException((BaseException)new ClientException(errorCode, errorMessage)));
    }

    @TargetApi(value=21)
    public void onReceivedClientCertRequest(@NonNull WebView view, final @NonNull ClientCertRequest clientCertRequest) {
        if (this.mCertBasedAuthChallengeHandler != null) {
            this.mCertBasedAuthChallengeHandler.cleanUp();
        }
        this.mCertBasedAuthFactory.createCertBasedAuthChallengeHandler(new CertBasedAuthFactory.CertBasedAuthChallengeHandlerCallback(){

            @Override
            public void onReceived(@Nullable ICertBasedAuthChallengeHandler challengeHandler) {
                AzureActiveDirectoryWebViewClient.this.mCertBasedAuthChallengeHandler = challengeHandler;
                if (AzureActiveDirectoryWebViewClient.this.mCertBasedAuthChallengeHandler == null) {
                    clientCertRequest.cancel();
                    return;
                }
                AzureActiveDirectoryWebViewClient.this.mCertBasedAuthChallengeHandler.processChallenge(clientCertRequest);
            }
        });
    }

    public void onDestroy() {
        if (this.mCertBasedAuthChallengeHandler != null) {
            this.mCertBasedAuthChallengeHandler.cleanUp();
        }
        this.mCertBasedAuthFactory.onDestroy();
    }

    public void emitTelemetryForCertBasedAuthResult(@NonNull RawAuthorizationResult response) {
        if (this.mCertBasedAuthChallengeHandler != null) {
            this.mCertBasedAuthChallengeHandler.emitTelemetryForCertBasedAuthResults(response);
        }
    }
}

