/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.platform;

import android.content.Context;
import android.os.Build;
import android.security.keystore.KeyGenParameterSpec;
import androidx.annotation.NonNull;
import com.microsoft.identity.common.components.AndroidPlatformComponentsFactory;
import com.microsoft.identity.common.internal.platform.AndroidDeviceKeyManager;
import com.microsoft.identity.common.internal.platform.AndroidSecretKeyAccessor;
import com.microsoft.identity.common.internal.platform.AsymmetricKeyAccessor;
import com.microsoft.identity.common.internal.platform.SymmetricCipher;
import com.microsoft.identity.common.java.crypto.CryptoSuite;
import com.microsoft.identity.common.java.crypto.IDevicePopManager;
import com.microsoft.identity.common.java.crypto.IKeyAccessor;
import com.microsoft.identity.common.java.crypto.IKeyStoreKeyManager;
import com.microsoft.identity.common.java.crypto.RawKeyAccessor;
import com.microsoft.identity.common.java.crypto.SecureHardwareState;
import com.microsoft.identity.common.java.crypto.SigningAlgorithm;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.interfaces.IPlatformComponents;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.UnrecoverableEntryException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.spec.AlgorithmParameterSpec;
import java.text.ParseException;
import java.util.UUID;
import javax.crypto.KeyGenerator;

public class AndroidKeyStoreAccessor {
    private static final String ANDROID_KEYSTORE = "AndroidKeyStore";
    public static final Charset UTF8 = Charset.forName("UTF-8");
    private static final int KEY_PURPOSES = 7;

    public static IKeyAccessor forAlias(@NonNull Context context, @NonNull String alias, @NonNull CryptoSuite suite) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException, ClientException {
        IPlatformComponents commonComponents = AndroidPlatformComponentsFactory.createFromContext(context);
        IDevicePopManager popManager = commonComponents.getDevicePopManager(alias);
        if (suite.cipher() instanceof IDevicePopManager.Cipher) {
            if (!popManager.asymmetricKeyExists()) {
                popManager.generateAsymmetricKey();
            }
            return AndroidKeyStoreAccessor.getKeyAccessor((IDevicePopManager.Cipher)suite.cipher(), suite.signingAlgorithm(), popManager);
        }
        KeyStore instance = KeyStore.getInstance(ANDROID_KEYSTORE);
        AndroidDeviceKeyManager keyManager = new AndroidDeviceKeyManager(instance, alias);
        return new AndroidSecretKeyAccessor(keyManager, suite){

            @Override
            public byte[] sign(byte[] text) throws ClientException {
                throw new UnsupportedOperationException("This key instance does not support signing");
            }

            @Override
            public boolean verify(byte[] text, byte[] signature) throws ClientException {
                throw new UnsupportedOperationException("This key instance does not support verification");
            }
        };
    }

    private static final IKeyAccessor getKeyAccessor(final @NonNull IDevicePopManager.Cipher cipher, final @NonNull SigningAlgorithm signingAlg, final @NonNull IDevicePopManager popManager) {
        return new AsymmetricKeyAccessor(){

            @Override
            public IKeyStoreKeyManager<KeyStore.PrivateKeyEntry> getManager() {
                return popManager.getKeyManager();
            }

            @Override
            public String getPublicKey(IDevicePopManager.PublicKeyFormat format) throws ClientException {
                return popManager.getPublicKey(format);
            }

            @Override
            public PublicKey getPublicKey() throws UnrecoverableEntryException, NoSuchAlgorithmException, KeyStoreException {
                return popManager.getPublicKey();
            }

            public byte[] encrypt(byte[] plaintext) throws ClientException {
                return popManager.encrypt(cipher, plaintext);
            }

            public byte[] decrypt(byte[] ciphertext) throws ClientException {
                return popManager.decrypt(cipher, ciphertext);
            }

            public byte[] sign(byte[] text) throws ClientException {
                return popManager.sign(signingAlg, text);
            }

            public boolean verify(byte[] text, byte[] signature) throws ClientException {
                return popManager.verify(signingAlg, text, signature);
            }

            public byte[] getThumbprint() throws ClientException {
                return popManager.getAsymmetricKeyThumbprint().getBytes(UTF8);
            }

            public Certificate[] getCertificateChain() throws ClientException {
                return popManager.getCertificateChain();
            }

            public SecureHardwareState getSecureHardwareState() throws ClientException {
                return popManager.getSecureHardwareState();
            }

            public IKeyAccessor generateDerivedKey(byte[] label, byte[] ctx, CryptoSuite suite) throws ClientException {
                throw new UnsupportedOperationException("This operation is not supported by asymmetric keys");
            }
        };
    }

    public static IKeyAccessor newInstance(@NonNull Context context, @NonNull IDevicePopManager.Cipher cipher, @NonNull SigningAlgorithm signingAlg) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException, ClientException {
        String alias = UUID.randomUUID().toString();
        IPlatformComponents commonComponents = AndroidPlatformComponentsFactory.createFromContext(context);
        IDevicePopManager popManager = commonComponents.getDevicePopManager(alias);
        popManager.generateAsymmetricKey();
        return AndroidKeyStoreAccessor.getKeyAccessor(cipher, signingAlg, popManager);
    }

    public static IKeyAccessor newInstance(@NonNull SymmetricCipher cipher, @NonNull boolean needRawAccess) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException, ClientException, NoSuchProviderException, InvalidAlgorithmParameterException {
        String alias = UUID.randomUUID().toString();
        if (Build.VERSION.SDK_INT >= 23 && !needRawAccess) {
            KeyStore instance = KeyStore.getInstance(ANDROID_KEYSTORE);
            instance.load(null);
            String[] params = cipher.cipher().name().split("/");
            KeyGenerator generator = KeyGenerator.getInstance(params[0], ANDROID_KEYSTORE);
            KeyGenParameterSpec spec = null;
            try {
                spec = Build.VERSION.SDK_INT >= 28 ? new KeyGenParameterSpec.Builder(alias, 7).setIsStrongBoxBacked(true).setKeySize(cipher.keySize()).setBlockModes(new String[]{params[1]}).setEncryptionPaddings(new String[]{params[2]}).setKeySize(cipher.keySize()).build() : new KeyGenParameterSpec.Builder(alias, 7).setKeySize(cipher.keySize()).setBlockModes(new String[]{params[1]}).setEncryptionPaddings(new String[]{params[2]}).setKeySize(cipher.keySize()).build();
                generator.init((AlgorithmParameterSpec)spec);
                generator.generateKey();
            }
            catch (ProviderException e) {
                if (e.getClass().getSimpleName().equals("StrongBoxUnavailableException")) {
                    spec = null;
                }
                throw e;
            }
            if (spec == null) {
                spec = new KeyGenParameterSpec.Builder(alias, 7).setKeySize(cipher.keySize()).setBlockModes(new String[]{params[1]}).setEncryptionPaddings(new String[]{params[2]}).setKeySize(cipher.keySize()).build();
                generator.init((AlgorithmParameterSpec)spec);
                generator.generateKey();
            }
            AndroidDeviceKeyManager keyManager = new AndroidDeviceKeyManager(instance, alias);
            return new AndroidSecretKeyAccessor(keyManager, (CryptoSuite)cipher){

                @Override
                public byte[] sign(byte[] text) throws ClientException {
                    throw new UnsupportedOperationException("This key instance does not support signing");
                }

                @Override
                public boolean verify(byte[] text, byte[] signature) throws ClientException {
                    throw new UnsupportedOperationException("This key instance does not support verification");
                }
            };
        }
        KeyGenerator generator = KeyGenerator.getInstance("AES");
        generator.init(cipher.mKeySize);
        byte[] key = generator.generateKey().getEncoded();
        return RawKeyAccessor.builder().suite((CryptoSuite)cipher).key(key).alias(alias).build();
    }

    public static IKeyAccessor importSymmetricKey(@NonNull Context context, @NonNull SymmetricCipher cipher, @NonNull String keyAlias, @NonNull String key_jwe, @NonNull IKeyAccessor stk_accessor) throws ParseException, CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException, ClientException {
        throw new UnsupportedOperationException("This operation is not yet supported");
    }
}

