/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.platform;

import android.os.Build;
import android.security.keystore.KeyInfo;
import com.microsoft.identity.common.java.crypto.SecureHardwareState;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.platform.AbstractKeyStoreKeyManager;
import com.microsoft.identity.common.logging.Logger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableEntryException;
import java.security.cert.Certificate;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import lombok.NonNull;

public class AndroidDeviceKeyManager<K extends KeyStore.Entry>
extends AbstractKeyStoreKeyManager<K> {
    private static final String TAG = AndroidDeviceKeyManager.class.getSimpleName();

    public AndroidDeviceKeyManager(@NonNull KeyStore keyStore, @NonNull String keyAlias) throws KeyStoreException {
        super(keyStore, keyAlias, null);
        if (keyStore == null) {
            throw new NullPointerException("keyStore is marked non-null but is null");
        }
        if (keyAlias == null) {
            throw new NullPointerException("keyAlias is marked non-null but is null");
        }
    }

    public void storeAsymmetricKey(@NonNull PrivateKey privateKey, @NonNull Certificate[] certChain) {
        if (privateKey == null) {
            throw new NullPointerException("privateKey is marked non-null but is null");
        }
        if (certChain == null) {
            throw new NullPointerException("certChain is marked non-null but is null");
        }
        throw new UnsupportedOperationException("This is not currently supported");
    }

    public SecureHardwareState getSecureHardwareState() throws ClientException {
        GeneralSecurityException exception;
        String errCode;
        String methodTag = TAG + ":getSecureHardwareState";
        try {
            KeyStore.Entry entry = this.getEntry();
            if (entry instanceof KeyStore.PrivateKeyEntry) {
                if (Build.VERSION.SDK_INT >= 23) {
                    try {
                        PrivateKey privateKey = ((KeyStore.PrivateKeyEntry)entry).getPrivateKey();
                        KeyFactory factory = KeyFactory.getInstance(privateKey.getAlgorithm(), this.mKeyStore.getProvider());
                        KeyInfo info = factory.getKeySpec(privateKey, KeyInfo.class);
                        boolean isInsideSecureHardware = info.isInsideSecureHardware();
                        Logger.info(methodTag, "PrivateKey is secure hardware backed? " + isInsideSecureHardware);
                        return isInsideSecureHardware ? SecureHardwareState.TRUE_UNATTESTED : SecureHardwareState.FALSE;
                    }
                    catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
                        Logger.error(methodTag, "Failed to query secure hardware state.", e);
                        return SecureHardwareState.UNKNOWN_QUERY_ERROR;
                    }
                }
                Logger.info(methodTag, "Cannot query secure hardware state (API unavailable <23)");
                return SecureHardwareState.UNKNOWN_DOWNLEVEL;
            }
            if (entry instanceof KeyStore.SecretKeyEntry) {
                if (Build.VERSION.SDK_INT >= 23) {
                    try {
                        SecretKey privateKey = ((KeyStore.SecretKeyEntry)entry).getSecretKey();
                        SecretKeyFactory factory = SecretKeyFactory.getInstance(privateKey.getAlgorithm(), this.mKeyStore.getProvider());
                        KeyInfo info = (KeyInfo)factory.getKeySpec(privateKey, KeyInfo.class);
                        boolean isInsideSecureHardware = info.isInsideSecureHardware();
                        Logger.info(methodTag, "SecretKey is secure hardware backed? " + isInsideSecureHardware);
                        return isInsideSecureHardware ? SecureHardwareState.TRUE_UNATTESTED : SecureHardwareState.FALSE;
                    }
                    catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
                        Logger.error(methodTag, "Failed to query secure hardware state.", e);
                        return SecureHardwareState.UNKNOWN_QUERY_ERROR;
                    }
                }
                Logger.info(methodTag, "Cannot query secure hardware state (API unavailable <23)");
                return SecureHardwareState.UNKNOWN_DOWNLEVEL;
            }
            throw new ClientException("unknown_error", "Cannot handle entries of type " + entry.getClass().getCanonicalName());
        }
        catch (KeyStoreException e) {
            errCode = "keystore_not_initialized";
            exception = e;
        }
        catch (NoSuchAlgorithmException e) {
            errCode = "no_such_algorithm";
            exception = e;
        }
        catch (UnrecoverableEntryException e) {
            errCode = "protection_params_invalid";
            exception = e;
        }
        ClientException clientException = new ClientException(errCode, exception.getMessage(), (Throwable)exception);
        Logger.error(methodTag, errCode, exception);
        throw clientException;
    }

    public static <K extends KeyStore.Entry> AndroidDeviceKeyManagerBuilder<K> builder() {
        return new AndroidDeviceKeyManagerBuilder();
    }

    public static class AndroidDeviceKeyManagerBuilder<K extends KeyStore.Entry> {
        private KeyStore keyStore;
        private String keyAlias;

        AndroidDeviceKeyManagerBuilder() {
        }

        public AndroidDeviceKeyManagerBuilder<K> keyStore(@NonNull KeyStore keyStore) {
            if (keyStore == null) {
                throw new NullPointerException("keyStore is marked non-null but is null");
            }
            this.keyStore = keyStore;
            return this;
        }

        public AndroidDeviceKeyManagerBuilder<K> keyAlias(@NonNull String keyAlias) {
            if (keyAlias == null) {
                throw new NullPointerException("keyAlias is marked non-null but is null");
            }
            this.keyAlias = keyAlias;
            return this;
        }

        public AndroidDeviceKeyManager<K> build() throws KeyStoreException {
            return new AndroidDeviceKeyManager(this.keyStore, this.keyAlias);
        }

        public String toString() {
            return "AndroidDeviceKeyManager.AndroidDeviceKeyManagerBuilder(keyStore=" + this.keyStore + ", keyAlias=" + this.keyAlias + ")";
        }
    }
}

