/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.commands;

import androidx.annotation.NonNull;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.java.commands.BaseCommand;
import com.microsoft.identity.common.java.commands.CommandCallback;
import com.microsoft.identity.common.java.commands.parameters.CommandParameters;
import com.microsoft.identity.common.java.commands.parameters.RemoveAccountCommandParameters;
import com.microsoft.identity.common.java.controllers.BaseController;
import java.util.List;

public class RemoveCurrentAccountCommand
extends BaseCommand<Boolean> {
    private static final String TAG = RemoveCurrentAccountCommand.class.getSimpleName();

    public RemoveCurrentAccountCommand(@NonNull RemoveAccountCommandParameters parameters, @NonNull BaseController controller, @NonNull CommandCallback callback, @NonNull String publicApiId) {
        super((CommandParameters)parameters, controller, callback, publicApiId);
    }

    public RemoveCurrentAccountCommand(@NonNull RemoveAccountCommandParameters parameters, @NonNull List<BaseController> controllers, @NonNull CommandCallback callback, @NonNull String publicApiId) {
        super((CommandParameters)parameters, controllers, callback, publicApiId);
    }

    public Boolean execute() throws Exception {
        String methodTag = TAG + ":execute";
        for (BaseController controller : this.getControllers()) {
            Logger.verbose(methodTag, "Executing with controller: " + controller.getClass().getSimpleName());
            boolean removed = controller.removeCurrentAccount((RemoveAccountCommandParameters)this.getParameters());
            if (!removed) continue;
            return true;
        }
        return false;
    }

    public boolean isEligibleForEstsTelemetry() {
        return true;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveCurrentAccountCommand)) {
            return false;
        }
        RemoveCurrentAccountCommand other = (RemoveCurrentAccountCommand)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(Object other) {
        return other instanceof RemoveCurrentAccountCommand;
    }

    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

