/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.commands;

import androidx.annotation.NonNull;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.java.cache.ICacheRecord;
import com.microsoft.identity.common.java.commands.BaseCommand;
import com.microsoft.identity.common.java.commands.CommandCallback;
import com.microsoft.identity.common.java.commands.parameters.CommandParameters;
import com.microsoft.identity.common.java.controllers.BaseController;
import java.util.ArrayList;
import java.util.List;

public class GetCurrentAccountCommand
extends BaseCommand<List<ICacheRecord>> {
    private static final String TAG = GetCurrentAccountCommand.class.getSimpleName();

    public GetCurrentAccountCommand(@NonNull CommandParameters parameters, @NonNull BaseController controller, @NonNull CommandCallback callback, @NonNull String publicApiId) {
        super(parameters, controller, callback, publicApiId);
    }

    public GetCurrentAccountCommand(@NonNull CommandParameters parameters, @NonNull List<BaseController> controllers, @NonNull CommandCallback callback, @NonNull String publicApiId) {
        super(parameters, controllers, callback, publicApiId);
    }

    public List<ICacheRecord> execute() throws Exception {
        String methodTag = TAG + ":execute";
        ArrayList<ICacheRecord> result = new ArrayList<ICacheRecord>();
        for (int ii = 0; ii < this.getControllers().size(); ++ii) {
            BaseController controller = (BaseController)this.getControllers().get(ii);
            Logger.verbose(methodTag, "Executing with controller: " + controller.getClass().getSimpleName());
            result.addAll(controller.getCurrentAccount(this.getParameters()));
        }
        return result;
    }

    public boolean isEligibleForEstsTelemetry() {
        return true;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetCurrentAccountCommand)) {
            return false;
        }
        GetCurrentAccountCommand other = (GetCurrentAccountCommand)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(Object other) {
        return other instanceof GetCurrentAccountCommand;
    }

    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

