/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.broker;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.SystemClock;
import android.util.LruCache;
import com.microsoft.identity.common.java.telemetry.Telemetry;
import com.microsoft.identity.common.java.telemetry.events.BaseEvent;
import com.microsoft.identity.common.java.telemetry.events.ContentProviderCallEvent;
import com.microsoft.identity.common.java.util.StringUtil;
import com.microsoft.identity.common.logging.Logger;
import lombok.NonNull;

public class IntuneMAMEnrollmentIdGateway {
    static IntuneMAMEnrollmentIdGateway sInstance;
    private static String CONTENT_URI;
    private static String SELECTION;
    private static String[] PROJECTION;
    private static final String TAG = "IntuneMAMEnrollmentIdGateway";
    private static final long CACHE_TTL_MS = 2000L;
    private static final int CACHE_SIZE = 10;
    private static final long CACHE_TTL_FOR_NULLS_MS = 1500L;
    private final LruCache<CacheKey, CacheEntry> mIdCache = new LruCache(10);

    public static synchronized IntuneMAMEnrollmentIdGateway getInstance() {
        if (sInstance == null) {
            sInstance = new IntuneMAMEnrollmentIdGateway();
        }
        return sInstance;
    }

    private IntuneMAMEnrollmentIdGateway() {
    }

    public synchronized String getEnrollmentId(Context context, String userId, String packageName) {
        CacheKey key = new CacheKey(userId, packageName);
        CacheEntry entry = (CacheEntry)this.mIdCache.get((Object)key);
        if (entry == null || entry.expired()) {
            String enrollmentId = this.callContentProvider(context, userId, packageName);
            entry = new CacheEntry(enrollmentId);
            this.mIdCache.put((Object)key, (Object)entry);
        }
        return entry.enrollmentId;
    }

    private String callContentProvider(Context context, String userId, String packageName) {
        String methodTag = "IntuneMAMEnrollmentIdGateway:callContentProvider";
        String[] selectionArgs = new String[]{packageName, userId};
        Uri contentURI = Uri.parse((String)CONTENT_URI);
        ContentProviderCallEvent getEnrollmentIdEvent = new ContentProviderCallEvent(CONTENT_URI);
        String result = null;
        try {
            Cursor found = context.getContentResolver().query(contentURI, PROJECTION, SELECTION, selectionArgs, null);
            if (found != null) {
                if (found.moveToFirst()) {
                    result = found.getString(0);
                }
                found.close();
            } else {
                Logger.verbose("IntuneMAMEnrollmentIdGateway:callContentProvider", "Cursor was null.  The content provider may not be available. ");
            }
        }
        catch (Exception e) {
            Logger.warn("IntuneMAMEnrollmentIdGateway:callContentProvider", "Unable to query enrollment id: " + e.getMessage());
        }
        getEnrollmentIdEvent.put("Microsoft.MSAL.enrollment_id_null", String.valueOf(StringUtil.isNullOrEmpty(result)));
        getEnrollmentIdEvent.put("Microsoft.MSAL.stop_time", String.valueOf(System.currentTimeMillis()));
        Telemetry.emit((BaseEvent)getEnrollmentIdEvent);
        return result;
    }

    static {
        CONTENT_URI = "content://com.microsoft.intune.mam.policy/mamserviceenrollments";
        SELECTION = "WHERE PackageName = ? AND Identity = ?";
        PROJECTION = new String[]{"EnrollmentId"};
    }

    private static final class CacheEntry {
        public final String enrollmentId;
        public final long timestampMs;

        public CacheEntry(String enrollmentId) {
            this.enrollmentId = enrollmentId;
            this.timestampMs = SystemClock.elapsedRealtime();
        }

        public boolean expired() {
            long timeoutMs = this.enrollmentId == null ? 1500L : 2000L;
            return SystemClock.elapsedRealtime() - this.timestampMs > timeoutMs;
        }
    }

    private static final class CacheKey {
        public final String userId;
        public final String packageName;

        public CacheKey(@NonNull String userId, @NonNull String packageName) {
            if (userId == null) {
                throw new NullPointerException("userId is marked non-null but is null");
            }
            if (packageName == null) {
                throw new NullPointerException("packageName is marked non-null but is null");
            }
            this.userId = userId.toLowerCase();
            this.packageName = packageName.toLowerCase();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            String this$userId = this.userId;
            String other$userId = other.userId;
            if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
                return false;
            }
            String this$packageName = this.packageName;
            String other$packageName = other.packageName;
            return !(this$packageName == null ? other$packageName != null : !this$packageName.equals(other$packageName));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $userId = this.userId;
            result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
            String $packageName = this.packageName;
            result = result * 59 + ($packageName == null ? 43 : $packageName.hashCode());
            return result;
        }
    }
}

