/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.components;

import android.content.Context;
import androidx.annotation.Nullable;
import com.microsoft.identity.common.internal.platform.AndroidDevicePopManager;
import com.microsoft.identity.common.java.crypto.IDevicePopManager;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.interfaces.IPopManagerSupplier;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import lombok.NonNull;

public class AndroidPopManagerSupplier
implements IPopManagerSupplier {
    @NonNull
    private final Context mContext;

    @NonNull
    public IDevicePopManager getDevicePopManager(@Nullable String alias) throws ClientException {
        String errCode;
        Exception exception;
        try {
            if (alias == null) {
                return new AndroidDevicePopManager(this.mContext);
            }
            return new AndroidDevicePopManager(this.mContext, alias);
        }
        catch (KeyStoreException e) {
            exception = e;
            errCode = "keystore_not_initialized";
        }
        catch (CertificateException e) {
            exception = e;
            errCode = "certificate_load_failure";
        }
        catch (NoSuchAlgorithmException e) {
            exception = e;
            errCode = "no_such_algorithm";
        }
        catch (IOException e) {
            exception = e;
            errCode = "io_error";
        }
        throw new ClientException(errCode, "Failed to initialize DevicePoPManager = " + exception.getMessage(), (Throwable)exception);
    }

    public AndroidPopManagerSupplier(@NonNull Context mContext) {
        if (mContext == null) {
            throw new NullPointerException("mContext is marked non-null but is null");
        }
        this.mContext = mContext;
    }
}

