/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client.internal.api;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.microsoft.identity.client.exception.MsalClientException;
import com.microsoft.identity.common.AndroidPlatformComponents;
import com.microsoft.identity.common.internal.broker.BrokerValidator;
import com.microsoft.identity.common.java.authscheme.AbstractAuthenticationScheme;
import com.microsoft.identity.common.java.authscheme.BearerAuthenticationSchemeInternal;
import com.microsoft.identity.common.java.cache.ICacheRecord;
import com.microsoft.identity.common.java.cache.MsalOAuth2TokenCache;
import com.microsoft.identity.common.java.dto.AccountRecord;
import com.microsoft.identity.common.java.dto.Credential;
import com.microsoft.identity.common.java.interfaces.IPlatformComponents;
import com.microsoft.identity.common.logging.Logger;

public final class BrokerClientIdRefreshTokenAccessor {
    private static final String TAG = BrokerClientIdRefreshTokenAccessor.class.getSimpleName();

    @Nullable
    public static String get(@NonNull Context context, @NonNull String accountObjectId) throws MsalClientException {
        String methodTag = TAG + ":get";
        BrokerClientIdRefreshTokenAccessor.throwIfNotValidBroker(context);
        MsalOAuth2TokenCache tokenCache = MsalOAuth2TokenCache.create((IPlatformComponents)AndroidPlatformComponents.createFromContext((Context)context));
        String applicationIdentitifier = String.format("%s/%s", null, null);
        ICacheRecord cacheRecord = BrokerClientIdRefreshTokenAccessor.getCacheRecordForIdentifier(tokenCache, accountObjectId, applicationIdentitifier);
        if (cacheRecord == null) {
            Logger.verbose((String)methodTag, (String)"No cache record found.");
            return null;
        }
        tokenCache.removeCredential((Credential)cacheRecord.getRefreshToken());
        tokenCache.removeCredential((Credential)cacheRecord.getAccessToken());
        if (cacheRecord.getRefreshToken() == null) {
            Logger.verbose((String)methodTag, (String)"Refresh token record is empty.");
            return null;
        }
        return cacheRecord.getRefreshToken().getSecret();
    }

    private static ICacheRecord getCacheRecordForIdentifier(@NonNull MsalOAuth2TokenCache tokenCache, @NonNull String accountObjectId, @NonNull String applicationIdentifier) throws MsalClientException {
        AccountRecord localAccountRecord = tokenCache.getAccountByLocalAccountId(null, "29d9ed98-a469-4536-ade2-f981bc1d605e", accountObjectId);
        if (null == localAccountRecord) {
            throw new MsalClientException("token_cache_item_not_found");
        }
        return tokenCache.load("29d9ed98-a469-4536-ade2-f981bc1d605e", applicationIdentifier, null, null, localAccountRecord, (AbstractAuthenticationScheme)new BearerAuthenticationSchemeInternal());
    }

    private static void throwIfNotValidBroker(Context context) throws MsalClientException {
        BrokerValidator brokerValidator = new BrokerValidator(context);
        if (!brokerValidator.isValidBrokerPackage(context.getPackageName())) {
            throw new MsalClientException("not_eligible_to_use_broker", "This can only be invoked by Broker apps.");
        }
    }
}

