/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.extensions.IUserActivityCollectionPage;
import com.microsoft.graph.extensions.IUserActivityCollectionRequest;
import com.microsoft.graph.extensions.UserActivity;
import com.microsoft.graph.extensions.UserActivityCollectionPage;
import com.microsoft.graph.extensions.UserActivityCollectionRequest;
import com.microsoft.graph.extensions.UserActivityCollectionRequestBuilder;
import com.microsoft.graph.extensions.UserActivityRequestBuilder;
import com.microsoft.graph.generated.BaseUserActivityCollectionResponse;
import com.microsoft.graph.generated.IBaseUserActivityCollectionRequest;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import java.util.List;

public class BaseUserActivityCollectionRequest
extends BaseCollectionRequest<BaseUserActivityCollectionResponse, IUserActivityCollectionPage>
implements IBaseUserActivityCollectionRequest {
    public BaseUserActivityCollectionRequest(String requestUrl, IBaseClient client, List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseUserActivityCollectionResponse.class, IUserActivityCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IUserActivityCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseUserActivityCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IUserActivityCollectionPage get() throws ClientException {
        BaseUserActivityCollectionResponse response = (BaseUserActivityCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(UserActivity newUserActivity, ICallback<UserActivity> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new UserActivityRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newUserActivity, callback);
    }

    @Override
    public UserActivity post(UserActivity newUserActivity) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new UserActivityRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newUserActivity);
    }

    @Override
    public IUserActivityCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (UserActivityCollectionRequest)this;
    }

    @Override
    public IUserActivityCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (UserActivityCollectionRequest)this;
    }

    @Override
    public IUserActivityCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (UserActivityCollectionRequest)this;
    }

    public IUserActivityCollectionPage buildFromResponse(BaseUserActivityCollectionResponse response) {
        UserActivityCollectionRequestBuilder builder = response.nextLink != null ? new UserActivityCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        UserActivityCollectionPage page = new UserActivityCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

