/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.extensions.Group;
import com.microsoft.graph.extensions.GroupWithReferenceRequest;
import com.microsoft.graph.extensions.IGroupWithReferenceRequest;
import com.microsoft.graph.generated.IBaseGroupWithReferenceRequest;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.serializer.IJsonBackedObject;
import java.util.List;

public class BaseGroupWithReferenceRequest
extends BaseRequest
implements IBaseGroupWithReferenceRequest {
    public BaseGroupWithReferenceRequest(String requestUrl, IBaseClient client, List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, Group.class);
    }

    @Override
    public void post(Group newGroup, IJsonBackedObject payload, ICallback<Group> callback) {
        this.send(HttpMethod.POST, callback, payload);
    }

    @Override
    public Group post(Group newGroup, IJsonBackedObject payload) throws ClientException {
        IJsonBackedObject response = (IJsonBackedObject)this.send(HttpMethod.POST, payload);
        if (response != null) {
            return newGroup;
        }
        return null;
    }

    @Override
    public void get(ICallback<Group> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public Group get() throws ClientException {
        return (Group)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<Group> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(Group sourceGroup, ICallback<Group> callback) {
        this.send(HttpMethod.PATCH, callback, sourceGroup);
    }

    @Override
    public Group patch(Group sourceGroup) throws ClientException {
        return (Group)this.send(HttpMethod.PATCH, sourceGroup);
    }

    @Override
    public IGroupWithReferenceRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return (IGroupWithReferenceRequest)((Object)this);
    }

    @Override
    public IGroupWithReferenceRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return (GroupWithReferenceRequest)this;
    }
}

