/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.extensions.DriveItemVersion;
import com.microsoft.graph.extensions.DriveItemVersionCollectionPage;
import com.microsoft.graph.extensions.DriveItemVersionCollectionRequest;
import com.microsoft.graph.extensions.DriveItemVersionCollectionRequestBuilder;
import com.microsoft.graph.extensions.DriveItemVersionRequestBuilder;
import com.microsoft.graph.extensions.IDriveItemVersionCollectionPage;
import com.microsoft.graph.extensions.IDriveItemVersionCollectionRequest;
import com.microsoft.graph.generated.BaseDriveItemVersionCollectionResponse;
import com.microsoft.graph.generated.IBaseDriveItemVersionCollectionRequest;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import java.util.List;

public class BaseDriveItemVersionCollectionRequest
extends BaseCollectionRequest<BaseDriveItemVersionCollectionResponse, IDriveItemVersionCollectionPage>
implements IBaseDriveItemVersionCollectionRequest {
    public BaseDriveItemVersionCollectionRequest(String requestUrl, IBaseClient client, List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseDriveItemVersionCollectionResponse.class, IDriveItemVersionCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IDriveItemVersionCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseDriveItemVersionCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IDriveItemVersionCollectionPage get() throws ClientException {
        BaseDriveItemVersionCollectionResponse response = (BaseDriveItemVersionCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(DriveItemVersion newDriveItemVersion, ICallback<DriveItemVersion> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new DriveItemVersionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newDriveItemVersion, callback);
    }

    @Override
    public DriveItemVersion post(DriveItemVersion newDriveItemVersion) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new DriveItemVersionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newDriveItemVersion);
    }

    @Override
    public IDriveItemVersionCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (DriveItemVersionCollectionRequest)this;
    }

    @Override
    public IDriveItemVersionCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (DriveItemVersionCollectionRequest)this;
    }

    @Override
    public IDriveItemVersionCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (DriveItemVersionCollectionRequest)this;
    }

    public IDriveItemVersionCollectionPage buildFromResponse(BaseDriveItemVersionCollectionResponse response) {
        DriveItemVersionCollectionRequestBuilder builder = response.nextLink != null ? new DriveItemVersionCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        DriveItemVersionCollectionPage page = new DriveItemVersionCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

