// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Base Workbook Chart Series Format Request.
 */
public interface IBaseWorkbookChartSeriesFormatRequest extends IHttpRequest {

    /**
     * Gets the WorkbookChartSeriesFormat from the service
     * @param callback The callback to be called after success or failure.
     */
    void get(final ICallback<WorkbookChartSeriesFormat> callback);

    /**
     * Gets the WorkbookChartSeriesFormat from the service
     * @return The WorkbookChartSeriesFormat from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    WorkbookChartSeriesFormat get() throws ClientException;

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    void delete(final ICallback<Void> callback);

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this WorkbookChartSeriesFormat with a source
     * @param sourceWorkbookChartSeriesFormat The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    void patch(final WorkbookChartSeriesFormat sourceWorkbookChartSeriesFormat, final ICallback<WorkbookChartSeriesFormat> callback);

    /**
     * Patches this WorkbookChartSeriesFormat with a source
     * @param sourceWorkbookChartSeriesFormat The source object with updates
     * @return The updated WorkbookChartSeriesFormat
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    WorkbookChartSeriesFormat patch(final WorkbookChartSeriesFormat sourceWorkbookChartSeriesFormat) throws ClientException;

    /**
     * Posts a WorkbookChartSeriesFormat with a new object
     * @param newWorkbookChartSeriesFormat The new object to create
     * @param callback The callback to be called after success or failure.
     */
    void post(final WorkbookChartSeriesFormat newWorkbookChartSeriesFormat, final ICallback<WorkbookChartSeriesFormat> callback);

    /**
     * Posts a WorkbookChartSeriesFormat with a new object
     * @param newWorkbookChartSeriesFormat The new object to create
     * @return The created WorkbookChartSeriesFormat
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    WorkbookChartSeriesFormat post(final WorkbookChartSeriesFormat newWorkbookChartSeriesFormat) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    IBaseWorkbookChartSeriesFormatRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    IBaseWorkbookChartSeriesFormatRequest expand(final String value);

}

