// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Base Shared Drive Item Request.
 */
public interface IBaseSharedDriveItemRequest extends IHttpRequest {

    /**
     * Gets the SharedDriveItem from the service
     * @param callback The callback to be called after success or failure.
     */
    void get(final ICallback<SharedDriveItem> callback);

    /**
     * Gets the SharedDriveItem from the service
     * @return The SharedDriveItem from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    SharedDriveItem get() throws ClientException;

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    void delete(final ICallback<Void> callback);

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this SharedDriveItem with a source
     * @param sourceSharedDriveItem The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    void patch(final SharedDriveItem sourceSharedDriveItem, final ICallback<SharedDriveItem> callback);

    /**
     * Patches this SharedDriveItem with a source
     * @param sourceSharedDriveItem The source object with updates
     * @return The updated SharedDriveItem
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    SharedDriveItem patch(final SharedDriveItem sourceSharedDriveItem) throws ClientException;

    /**
     * Posts a SharedDriveItem with a new object
     * @param newSharedDriveItem The new object to create
     * @param callback The callback to be called after success or failure.
     */
    void post(final SharedDriveItem newSharedDriveItem, final ICallback<SharedDriveItem> callback);

    /**
     * Posts a SharedDriveItem with a new object
     * @param newSharedDriveItem The new object to create
     * @return The created SharedDriveItem
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    SharedDriveItem post(final SharedDriveItem newSharedDriveItem) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    IBaseSharedDriveItemRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    IBaseSharedDriveItemRequest expand(final String value);

}

