// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Base Onenote Section Request.
 */
public interface IBaseOnenoteSectionRequest extends IHttpRequest {

    /**
     * Gets the OnenoteSection from the service
     * @param callback The callback to be called after success or failure.
     */
    void get(final ICallback<OnenoteSection> callback);

    /**
     * Gets the OnenoteSection from the service
     * @return The OnenoteSection from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    OnenoteSection get() throws ClientException;

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    void delete(final ICallback<Void> callback);

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this OnenoteSection with a source
     * @param sourceOnenoteSection The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    void patch(final OnenoteSection sourceOnenoteSection, final ICallback<OnenoteSection> callback);

    /**
     * Patches this OnenoteSection with a source
     * @param sourceOnenoteSection The source object with updates
     * @return The updated OnenoteSection
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    OnenoteSection patch(final OnenoteSection sourceOnenoteSection) throws ClientException;

    /**
     * Posts a OnenoteSection with a new object
     * @param newOnenoteSection The new object to create
     * @param callback The callback to be called after success or failure.
     */
    void post(final OnenoteSection newOnenoteSection, final ICallback<OnenoteSection> callback);

    /**
     * Posts a OnenoteSection with a new object
     * @param newOnenoteSection The new object to create
     * @return The created OnenoteSection
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    OnenoteSection post(final OnenoteSection newOnenoteSection) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    IBaseOnenoteSectionRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    IBaseOnenoteSectionRequest expand(final String value);

}

