// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Base Domain Dns Mx Record Request.
 */
public interface IBaseDomainDnsMxRecordRequest extends IHttpRequest {

    /**
     * Gets the DomainDnsMxRecord from the service
     * @param callback The callback to be called after success or failure.
     */
    void get(final ICallback<DomainDnsMxRecord> callback);

    /**
     * Gets the DomainDnsMxRecord from the service
     * @return The DomainDnsMxRecord from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    DomainDnsMxRecord get() throws ClientException;

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    void delete(final ICallback<Void> callback);

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this DomainDnsMxRecord with a source
     * @param sourceDomainDnsMxRecord The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    void patch(final DomainDnsMxRecord sourceDomainDnsMxRecord, final ICallback<DomainDnsMxRecord> callback);

    /**
     * Patches this DomainDnsMxRecord with a source
     * @param sourceDomainDnsMxRecord The source object with updates
     * @return The updated DomainDnsMxRecord
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    DomainDnsMxRecord patch(final DomainDnsMxRecord sourceDomainDnsMxRecord) throws ClientException;

    /**
     * Posts a DomainDnsMxRecord with a new object
     * @param newDomainDnsMxRecord The new object to create
     * @param callback The callback to be called after success or failure.
     */
    void post(final DomainDnsMxRecord newDomainDnsMxRecord, final ICallback<DomainDnsMxRecord> callback);

    /**
     * Posts a DomainDnsMxRecord with a new object
     * @param newDomainDnsMxRecord The new object to create
     * @return The created DomainDnsMxRecord
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    DomainDnsMxRecord post(final DomainDnsMxRecord newDomainDnsMxRecord) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    IBaseDomainDnsMxRecordRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    IBaseDomainDnsMxRecordRequest expand(final String value);

}

