// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Workbook Table Request.
 */
public class BaseWorkbookTableRequest extends BaseRequest implements IBaseWorkbookTableRequest {

    /**
     * The request for the WorkbookTable
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     * @param responseClass The class of the reponse
     */
    public BaseWorkbookTableRequest(final String requestUrl,
            final IBaseClient client,
            final java.util.List<Option> requestOptions,
            final Class responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * Gets the WorkbookTable from the service
     * @param callback The callback to be called after success or failure.
     */
    public void get(final ICallback<WorkbookTable> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the WorkbookTable from the service
     * @return The WorkbookTable from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public WorkbookTable get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    public void delete(final ICallback<Void> callback) {{
        send(HttpMethod.DELETE, callback, null);
    }}

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {{
        send(HttpMethod.DELETE, null);
    }}

    /**
     * Patches this WorkbookTable with a source
     * @param sourceWorkbookTable The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    public void patch(final WorkbookTable sourceWorkbookTable, final ICallback<WorkbookTable> callback) {
        send(HttpMethod.PATCH, callback, sourceWorkbookTable);
    }

    /**
     * Patches this WorkbookTable with a source
     * @param sourceWorkbookTable The source object with updates
     * @return The updated WorkbookTable
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public WorkbookTable patch(final WorkbookTable sourceWorkbookTable) throws ClientException {
        return send(HttpMethod.PATCH, sourceWorkbookTable);
    }

    /**
     * Creates a WorkbookTable with a new object
     * @param newWorkbookTable The new object to create
     * @param callback The callback to be called after success or failure.
     */
    public void post(final WorkbookTable newWorkbookTable, final ICallback<WorkbookTable> callback) {
        send(HttpMethod.POST, callback, newWorkbookTable);
    }

    /**
     * Creates a WorkbookTable with a new object
     * @param newWorkbookTable The new object to create
     * @return The created WorkbookTable
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public WorkbookTable post(final WorkbookTable newWorkbookTable) throws ClientException {
        return send(HttpMethod.POST, newWorkbookTable);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
     public IWorkbookTableRequest select(final String value) {
         getQueryOptions().add(new QueryOption("$select", value));
         return (WorkbookTableRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
     public IWorkbookTableRequest expand(final String value) {
         getQueryOptions().add(new QueryOption("$expand", value));
         return (WorkbookTableRequest)this;
     }

}

