// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;
// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Workbook Functions Sum If Request Builder.
 */
public class BaseWorkbookFunctionsSumIfRequestBuilder extends BaseActionRequestBuilder {

    /**
     * The request builder for this WorkbookFunctionsSumIf
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseWorkbookFunctionsSumIfRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<Option> requestOptions, final com.google.gson.JsonElement range, final com.google.gson.JsonElement criteria, final com.google.gson.JsonElement sumRange) {
        super(requestUrl, client, requestOptions);
        mBodyParams.put("range", range);
        mBodyParams.put("criteria", criteria);
        mBodyParams.put("sumRange", sumRange);
    }

    /**
     * Creates the IWorkbookFunctionsSumIfRequest
     *
     * @return The IWorkbookFunctionsSumIfRequest instance
     */
    public IWorkbookFunctionsSumIfRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the IWorkbookFunctionsSumIfRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return The IWorkbookFunctionsSumIfRequest instance
     */
    public IWorkbookFunctionsSumIfRequest buildRequest(final java.util.List<Option> requestOptions) {
        WorkbookFunctionsSumIfRequest request = new WorkbookFunctionsSumIfRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        if (hasParameter("range")) {
            request.mBody.range = getParameter("range");
        }

        if (hasParameter("criteria")) {
            request.mBody.criteria = getParameter("criteria");
        }

        if (hasParameter("sumRange")) {
            request.mBody.sumRange = getParameter("sumRange");
        }

        return request;
    }
}
