// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Workbook Chart Item Request.
 */
public class BaseWorkbookChartItemRequest extends BaseRequest implements IBaseWorkbookChartItemRequest {

    /**
     * The request for this WorkbookChartItem
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseWorkbookChartItemRequest(final String requestUrl, final IBaseClient client, final java.util.List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, WorkbookChart.class);
    }

    /**
     * Patches the WorkbookChartItem
     * @param srcWorkbookChart The WorkbookChart with which to PATCH
     * @param callback The callback to be called after success or failure
     */
    public void patch(WorkbookChart srcWorkbookChart, final ICallback<WorkbookChart> callback) {
        send(HttpMethod.PATCH, callback, srcWorkbookChart);
    }

    /**
     * Patches the WorkbookChartItem
     *
     * @param srcWorkbookChart The WorkbookChart with which to PATCH
     * @return The WorkbookChart
     * @throws ClientException An exception occurs if there was an error while the request was sent
     */
     public WorkbookChart patch(WorkbookChart srcWorkbookChart) throws ClientException {
        return this.send(HttpMethod.PATCH, srcWorkbookChart);
    }

    /**
     * Puts the WorkbookChartItem
     *
     * @param srcWorkbookChart The WorkbookChart to PUT
     * @param callback The callback to be called after success or failure
     */
    public void put(WorkbookChart srcWorkbookChart, final ICallback<WorkbookChart> callback) {
        send(HttpMethod.PUT, callback, srcWorkbookChart);
    }

    /**
     * Puts the WorkbookChartItem
     *
     * @param srcWorkbookChart The WorkbookChart to PUT
     * @return The WorkbookChart
     * @throws ClientException An exception occurs if there was an error while the request was sent
     */
     public WorkbookChart put(WorkbookChart srcWorkbookChart) throws ClientException {
        return this.send(HttpMethod.PUT, srcWorkbookChart);
    }
    /**
     * Gets the WorkbookChart
     *
     * @param callback The callback to be called after success or failure.
     */
    public void get(final ICallback<WorkbookChart> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the WorkbookChart
     *
     * @return The WorkbookChart
     * @throws ClientException An exception occurs if there was an error while the request was sent.
     */
    public WorkbookChart get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    public IWorkbookChartItemRequest select(final String value) {
        getQueryOptions().add(new QueryOption("$select", value));
        return (WorkbookChartItemRequest)this;
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    public IWorkbookChartItemRequest expand(final String value) {
        getQueryOptions().add(new QueryOption("$expand", value));
        return (WorkbookChartItemRequest)this;
    }

}
