// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Workbook Chart Font Request.
 */
public class BaseWorkbookChartFontRequest extends BaseRequest implements IBaseWorkbookChartFontRequest {

    /**
     * The request for the WorkbookChartFont
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     * @param responseClass The class of the reponse
     */
    public BaseWorkbookChartFontRequest(final String requestUrl,
            final IBaseClient client,
            final java.util.List<Option> requestOptions,
            final Class responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * Gets the WorkbookChartFont from the service
     * @param callback The callback to be called after success or failure.
     */
    public void get(final ICallback<WorkbookChartFont> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the WorkbookChartFont from the service
     * @return The WorkbookChartFont from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public WorkbookChartFont get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    public void delete(final ICallback<Void> callback) {{
        send(HttpMethod.DELETE, callback, null);
    }}

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {{
        send(HttpMethod.DELETE, null);
    }}

    /**
     * Patches this WorkbookChartFont with a source
     * @param sourceWorkbookChartFont The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    public void patch(final WorkbookChartFont sourceWorkbookChartFont, final ICallback<WorkbookChartFont> callback) {
        send(HttpMethod.PATCH, callback, sourceWorkbookChartFont);
    }

    /**
     * Patches this WorkbookChartFont with a source
     * @param sourceWorkbookChartFont The source object with updates
     * @return The updated WorkbookChartFont
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public WorkbookChartFont patch(final WorkbookChartFont sourceWorkbookChartFont) throws ClientException {
        return send(HttpMethod.PATCH, sourceWorkbookChartFont);
    }

    /**
     * Creates a WorkbookChartFont with a new object
     * @param newWorkbookChartFont The new object to create
     * @param callback The callback to be called after success or failure.
     */
    public void post(final WorkbookChartFont newWorkbookChartFont, final ICallback<WorkbookChartFont> callback) {
        send(HttpMethod.POST, callback, newWorkbookChartFont);
    }

    /**
     * Creates a WorkbookChartFont with a new object
     * @param newWorkbookChartFont The new object to create
     * @return The created WorkbookChartFont
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public WorkbookChartFont post(final WorkbookChartFont newWorkbookChartFont) throws ClientException {
        return send(HttpMethod.POST, newWorkbookChartFont);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
     public IWorkbookChartFontRequest select(final String value) {
         getQueryOptions().add(new QueryOption("$select", value));
         return (WorkbookChartFontRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
     public IWorkbookChartFontRequest expand(final String value) {
         getQueryOptions().add(new QueryOption("$expand", value));
         return (WorkbookChartFontRequest)this;
     }

}

