// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base User Activity Request.
 */
public class BaseUserActivityRequest extends BaseRequest implements IBaseUserActivityRequest {

    /**
     * The request for the UserActivity
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     * @param responseClass The class of the reponse
     */
    public BaseUserActivityRequest(final String requestUrl,
            final IBaseClient client,
            final java.util.List<Option> requestOptions,
            final Class responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * Gets the UserActivity from the service
     * @param callback The callback to be called after success or failure.
     */
    public void get(final ICallback<UserActivity> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the UserActivity from the service
     * @return The UserActivity from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public UserActivity get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    public void delete(final ICallback<Void> callback) {{
        send(HttpMethod.DELETE, callback, null);
    }}

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {{
        send(HttpMethod.DELETE, null);
    }}

    /**
     * Patches this UserActivity with a source
     * @param sourceUserActivity The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    public void patch(final UserActivity sourceUserActivity, final ICallback<UserActivity> callback) {
        send(HttpMethod.PATCH, callback, sourceUserActivity);
    }

    /**
     * Patches this UserActivity with a source
     * @param sourceUserActivity The source object with updates
     * @return The updated UserActivity
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public UserActivity patch(final UserActivity sourceUserActivity) throws ClientException {
        return send(HttpMethod.PATCH, sourceUserActivity);
    }

    /**
     * Creates a UserActivity with a new object
     * @param newUserActivity The new object to create
     * @param callback The callback to be called after success or failure.
     */
    public void post(final UserActivity newUserActivity, final ICallback<UserActivity> callback) {
        send(HttpMethod.POST, callback, newUserActivity);
    }

    /**
     * Creates a UserActivity with a new object
     * @param newUserActivity The new object to create
     * @return The created UserActivity
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public UserActivity post(final UserActivity newUserActivity) throws ClientException {
        return send(HttpMethod.POST, newUserActivity);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
     public IUserActivityRequest select(final String value) {
         getQueryOptions().add(new QueryOption("$select", value));
         return (UserActivityRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
     public IUserActivityRequest expand(final String value) {
         getQueryOptions().add(new QueryOption("$expand", value));
         return (UserActivityRequest)this;
     }

}

