// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Report Root Request Builder.
 */
public class BaseReportRootRequestBuilder extends BaseRequestBuilder implements IBaseReportRootRequestBuilder {

    /**
     * The request builder for the ReportRoot
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseReportRootRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     */
    public IReportRootRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     */
    public IReportRootRequest buildRequest(final java.util.List<Option> requestOptions) {
        return new ReportRootRequest(getRequestUrl(), getClient(), requestOptions);
    }


    public IReportRootGetOffice365ActivationsUserDetailRequestBuilder getGetOffice365ActivationsUserDetail() {
        return new ReportRootGetOffice365ActivationsUserDetailRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getOffice365ActivationsUserDetail"), getClient(), null);
    }

    public IReportRootGetOffice365ActivationCountsRequestBuilder getGetOffice365ActivationCounts() {
        return new ReportRootGetOffice365ActivationCountsRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getOffice365ActivationCounts"), getClient(), null);
    }

    public IReportRootGetOffice365ActivationsUserCountsRequestBuilder getGetOffice365ActivationsUserCounts() {
        return new ReportRootGetOffice365ActivationsUserCountsRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getOffice365ActivationsUserCounts"), getClient(), null);
    }

    public IReportRootGetOffice365ActiveUserDetailRequestBuilder getGetOffice365ActiveUserDetail(final com.microsoft.graph.model.DateOnly date) {
        return new ReportRootGetOffice365ActiveUserDetailRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getOffice365ActiveUserDetail"), getClient(), null, date);
    }

    public IReportRootGetOffice365ActiveUserDetailRequestBuilder getGetOffice365ActiveUserDetail(final String period) {
        return new ReportRootGetOffice365ActiveUserDetailRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getOffice365ActiveUserDetail"), getClient(), null, period);
    }

    public IReportRootGetOffice365ServicesUserCountsRequestBuilder getGetOffice365ServicesUserCounts(final String period) {
        return new ReportRootGetOffice365ServicesUserCountsRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getOffice365ServicesUserCounts"), getClient(), null, period);
    }

    public IReportRootGetOffice365ActiveUserCountsRequestBuilder getGetOffice365ActiveUserCounts(final String period) {
        return new ReportRootGetOffice365ActiveUserCountsRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getOffice365ActiveUserCounts"), getClient(), null, period);
    }

    public IReportRootGetOffice365GroupsActivityDetailRequestBuilder getGetOffice365GroupsActivityDetail(final com.microsoft.graph.model.DateOnly date) {
        return new ReportRootGetOffice365GroupsActivityDetailRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getOffice365GroupsActivityDetail"), getClient(), null, date);
    }

    public IReportRootGetOffice365GroupsActivityDetailRequestBuilder getGetOffice365GroupsActivityDetail(final String period) {
        return new ReportRootGetOffice365GroupsActivityDetailRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getOffice365GroupsActivityDetail"), getClient(), null, period);
    }

    public IReportRootGetOffice365GroupsActivityCountsRequestBuilder getGetOffice365GroupsActivityCounts(final String period) {
        return new ReportRootGetOffice365GroupsActivityCountsRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getOffice365GroupsActivityCounts"), getClient(), null, period);
    }

    public IReportRootGetOffice365GroupsActivityGroupCountsRequestBuilder getGetOffice365GroupsActivityGroupCounts(final String period) {
        return new ReportRootGetOffice365GroupsActivityGroupCountsRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getOffice365GroupsActivityGroupCounts"), getClient(), null, period);
    }

    public IReportRootGetOffice365GroupsActivityStorageRequestBuilder getGetOffice365GroupsActivityStorage(final String period) {
        return new ReportRootGetOffice365GroupsActivityStorageRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getOffice365GroupsActivityStorage"), getClient(), null, period);
    }

    public IReportRootGetOffice365GroupsActivityFileCountsRequestBuilder getGetOffice365GroupsActivityFileCounts(final String period) {
        return new ReportRootGetOffice365GroupsActivityFileCountsRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getOffice365GroupsActivityFileCounts"), getClient(), null, period);
    }

    public IReportRootGetEmailActivityUserDetailRequestBuilder getGetEmailActivityUserDetail(final com.microsoft.graph.model.DateOnly date) {
        return new ReportRootGetEmailActivityUserDetailRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getEmailActivityUserDetail"), getClient(), null, date);
    }

    public IReportRootGetEmailActivityUserDetailRequestBuilder getGetEmailActivityUserDetail(final String period) {
        return new ReportRootGetEmailActivityUserDetailRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getEmailActivityUserDetail"), getClient(), null, period);
    }

    public IReportRootGetEmailActivityCountsRequestBuilder getGetEmailActivityCounts(final String period) {
        return new ReportRootGetEmailActivityCountsRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getEmailActivityCounts"), getClient(), null, period);
    }

    public IReportRootGetEmailActivityUserCountsRequestBuilder getGetEmailActivityUserCounts(final String period) {
        return new ReportRootGetEmailActivityUserCountsRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getEmailActivityUserCounts"), getClient(), null, period);
    }

    public IReportRootGetEmailAppUsageUserDetailRequestBuilder getGetEmailAppUsageUserDetail(final com.microsoft.graph.model.DateOnly date) {
        return new ReportRootGetEmailAppUsageUserDetailRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getEmailAppUsageUserDetail"), getClient(), null, date);
    }

    public IReportRootGetEmailAppUsageUserDetailRequestBuilder getGetEmailAppUsageUserDetail(final String period) {
        return new ReportRootGetEmailAppUsageUserDetailRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getEmailAppUsageUserDetail"), getClient(), null, period);
    }

    public IReportRootGetEmailAppUsageAppsUserCountsRequestBuilder getGetEmailAppUsageAppsUserCounts(final String period) {
        return new ReportRootGetEmailAppUsageAppsUserCountsRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getEmailAppUsageAppsUserCounts"), getClient(), null, period);
    }

    public IReportRootGetEmailAppUsageUserCountsRequestBuilder getGetEmailAppUsageUserCounts(final String period) {
        return new ReportRootGetEmailAppUsageUserCountsRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getEmailAppUsageUserCounts"), getClient(), null, period);
    }

    public IReportRootGetEmailAppUsageVersionsUserCountsRequestBuilder getGetEmailAppUsageVersionsUserCounts(final String period) {
        return new ReportRootGetEmailAppUsageVersionsUserCountsRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getEmailAppUsageVersionsUserCounts"), getClient(), null, period);
    }

    public IReportRootGetMailboxUsageDetailRequestBuilder getGetMailboxUsageDetail(final String period) {
        return new ReportRootGetMailboxUsageDetailRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getMailboxUsageDetail"), getClient(), null, period);
    }

    public IReportRootGetMailboxUsageMailboxCountsRequestBuilder getGetMailboxUsageMailboxCounts(final String period) {
        return new ReportRootGetMailboxUsageMailboxCountsRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getMailboxUsageMailboxCounts"), getClient(), null, period);
    }

    public IReportRootGetMailboxUsageQuotaStatusMailboxCountsRequestBuilder getGetMailboxUsageQuotaStatusMailboxCounts(final String period) {
        return new ReportRootGetMailboxUsageQuotaStatusMailboxCountsRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getMailboxUsageQuotaStatusMailboxCounts"), getClient(), null, period);
    }

    public IReportRootGetMailboxUsageStorageRequestBuilder getGetMailboxUsageStorage(final String period) {
        return new ReportRootGetMailboxUsageStorageRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getMailboxUsageStorage"), getClient(), null, period);
    }

    public IReportRootGetOneDriveActivityUserDetailRequestBuilder getGetOneDriveActivityUserDetail(final com.microsoft.graph.model.DateOnly date) {
        return new ReportRootGetOneDriveActivityUserDetailRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getOneDriveActivityUserDetail"), getClient(), null, date);
    }

    public IReportRootGetOneDriveActivityUserDetailRequestBuilder getGetOneDriveActivityUserDetail(final String period) {
        return new ReportRootGetOneDriveActivityUserDetailRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getOneDriveActivityUserDetail"), getClient(), null, period);
    }

    public IReportRootGetOneDriveActivityUserCountsRequestBuilder getGetOneDriveActivityUserCounts(final String period) {
        return new ReportRootGetOneDriveActivityUserCountsRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getOneDriveActivityUserCounts"), getClient(), null, period);
    }

    public IReportRootGetOneDriveActivityFileCountsRequestBuilder getGetOneDriveActivityFileCounts(final String period) {
        return new ReportRootGetOneDriveActivityFileCountsRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getOneDriveActivityFileCounts"), getClient(), null, period);
    }

    public IReportRootGetOneDriveUsageAccountDetailRequestBuilder getGetOneDriveUsageAccountDetail(final com.microsoft.graph.model.DateOnly date) {
        return new ReportRootGetOneDriveUsageAccountDetailRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getOneDriveUsageAccountDetail"), getClient(), null, date);
    }

    public IReportRootGetOneDriveUsageAccountDetailRequestBuilder getGetOneDriveUsageAccountDetail(final String period) {
        return new ReportRootGetOneDriveUsageAccountDetailRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getOneDriveUsageAccountDetail"), getClient(), null, period);
    }

    public IReportRootGetOneDriveUsageAccountCountsRequestBuilder getGetOneDriveUsageAccountCounts(final String period) {
        return new ReportRootGetOneDriveUsageAccountCountsRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getOneDriveUsageAccountCounts"), getClient(), null, period);
    }

    public IReportRootGetOneDriveUsageFileCountsRequestBuilder getGetOneDriveUsageFileCounts(final String period) {
        return new ReportRootGetOneDriveUsageFileCountsRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getOneDriveUsageFileCounts"), getClient(), null, period);
    }

    public IReportRootGetOneDriveUsageStorageRequestBuilder getGetOneDriveUsageStorage(final String period) {
        return new ReportRootGetOneDriveUsageStorageRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getOneDriveUsageStorage"), getClient(), null, period);
    }

    public IReportRootGetSharePointActivityUserDetailRequestBuilder getGetSharePointActivityUserDetail(final com.microsoft.graph.model.DateOnly date) {
        return new ReportRootGetSharePointActivityUserDetailRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getSharePointActivityUserDetail"), getClient(), null, date);
    }

    public IReportRootGetSharePointActivityUserDetailRequestBuilder getGetSharePointActivityUserDetail(final String period) {
        return new ReportRootGetSharePointActivityUserDetailRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getSharePointActivityUserDetail"), getClient(), null, period);
    }

    public IReportRootGetSharePointActivityFileCountsRequestBuilder getGetSharePointActivityFileCounts(final String period) {
        return new ReportRootGetSharePointActivityFileCountsRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getSharePointActivityFileCounts"), getClient(), null, period);
    }

    public IReportRootGetSharePointActivityUserCountsRequestBuilder getGetSharePointActivityUserCounts(final String period) {
        return new ReportRootGetSharePointActivityUserCountsRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getSharePointActivityUserCounts"), getClient(), null, period);
    }

    public IReportRootGetSharePointActivityPagesRequestBuilder getGetSharePointActivityPages(final String period) {
        return new ReportRootGetSharePointActivityPagesRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getSharePointActivityPages"), getClient(), null, period);
    }

    public IReportRootGetSharePointSiteUsageDetailRequestBuilder getGetSharePointSiteUsageDetail(final com.microsoft.graph.model.DateOnly date) {
        return new ReportRootGetSharePointSiteUsageDetailRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getSharePointSiteUsageDetail"), getClient(), null, date);
    }

    public IReportRootGetSharePointSiteUsageDetailRequestBuilder getGetSharePointSiteUsageDetail(final String period) {
        return new ReportRootGetSharePointSiteUsageDetailRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getSharePointSiteUsageDetail"), getClient(), null, period);
    }

    public IReportRootGetSharePointSiteUsageFileCountsRequestBuilder getGetSharePointSiteUsageFileCounts(final String period) {
        return new ReportRootGetSharePointSiteUsageFileCountsRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getSharePointSiteUsageFileCounts"), getClient(), null, period);
    }

    public IReportRootGetSharePointSiteUsageSiteCountsRequestBuilder getGetSharePointSiteUsageSiteCounts(final String period) {
        return new ReportRootGetSharePointSiteUsageSiteCountsRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getSharePointSiteUsageSiteCounts"), getClient(), null, period);
    }

    public IReportRootGetSharePointSiteUsageStorageRequestBuilder getGetSharePointSiteUsageStorage(final String period) {
        return new ReportRootGetSharePointSiteUsageStorageRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getSharePointSiteUsageStorage"), getClient(), null, period);
    }

    public IReportRootGetSharePointSiteUsagePagesRequestBuilder getGetSharePointSiteUsagePages(final String period) {
        return new ReportRootGetSharePointSiteUsagePagesRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getSharePointSiteUsagePages"), getClient(), null, period);
    }

    public IReportRootGetSkypeForBusinessActivityUserDetailRequestBuilder getGetSkypeForBusinessActivityUserDetail(final com.microsoft.graph.model.DateOnly date) {
        return new ReportRootGetSkypeForBusinessActivityUserDetailRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getSkypeForBusinessActivityUserDetail"), getClient(), null, date);
    }

    public IReportRootGetSkypeForBusinessActivityUserDetailRequestBuilder getGetSkypeForBusinessActivityUserDetail(final String period) {
        return new ReportRootGetSkypeForBusinessActivityUserDetailRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getSkypeForBusinessActivityUserDetail"), getClient(), null, period);
    }

    public IReportRootGetSkypeForBusinessActivityCountsRequestBuilder getGetSkypeForBusinessActivityCounts(final String period) {
        return new ReportRootGetSkypeForBusinessActivityCountsRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getSkypeForBusinessActivityCounts"), getClient(), null, period);
    }

    public IReportRootGetSkypeForBusinessActivityUserCountsRequestBuilder getGetSkypeForBusinessActivityUserCounts(final String period) {
        return new ReportRootGetSkypeForBusinessActivityUserCountsRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getSkypeForBusinessActivityUserCounts"), getClient(), null, period);
    }

    public IReportRootGetSkypeForBusinessPeerToPeerActivityCountsRequestBuilder getGetSkypeForBusinessPeerToPeerActivityCounts(final String period) {
        return new ReportRootGetSkypeForBusinessPeerToPeerActivityCountsRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getSkypeForBusinessPeerToPeerActivityCounts"), getClient(), null, period);
    }

    public IReportRootGetSkypeForBusinessPeerToPeerActivityUserCountsRequestBuilder getGetSkypeForBusinessPeerToPeerActivityUserCounts(final String period) {
        return new ReportRootGetSkypeForBusinessPeerToPeerActivityUserCountsRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getSkypeForBusinessPeerToPeerActivityUserCounts"), getClient(), null, period);
    }

    public IReportRootGetSkypeForBusinessPeerToPeerActivityMinuteCountsRequestBuilder getGetSkypeForBusinessPeerToPeerActivityMinuteCounts(final String period) {
        return new ReportRootGetSkypeForBusinessPeerToPeerActivityMinuteCountsRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getSkypeForBusinessPeerToPeerActivityMinuteCounts"), getClient(), null, period);
    }

    public IReportRootGetSkypeForBusinessOrganizerActivityCountsRequestBuilder getGetSkypeForBusinessOrganizerActivityCounts(final String period) {
        return new ReportRootGetSkypeForBusinessOrganizerActivityCountsRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getSkypeForBusinessOrganizerActivityCounts"), getClient(), null, period);
    }

    public IReportRootGetSkypeForBusinessOrganizerActivityUserCountsRequestBuilder getGetSkypeForBusinessOrganizerActivityUserCounts(final String period) {
        return new ReportRootGetSkypeForBusinessOrganizerActivityUserCountsRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getSkypeForBusinessOrganizerActivityUserCounts"), getClient(), null, period);
    }

    public IReportRootGetSkypeForBusinessOrganizerActivityMinuteCountsRequestBuilder getGetSkypeForBusinessOrganizerActivityMinuteCounts(final String period) {
        return new ReportRootGetSkypeForBusinessOrganizerActivityMinuteCountsRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getSkypeForBusinessOrganizerActivityMinuteCounts"), getClient(), null, period);
    }

    public IReportRootGetSkypeForBusinessParticipantActivityCountsRequestBuilder getGetSkypeForBusinessParticipantActivityCounts(final String period) {
        return new ReportRootGetSkypeForBusinessParticipantActivityCountsRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getSkypeForBusinessParticipantActivityCounts"), getClient(), null, period);
    }

    public IReportRootGetSkypeForBusinessParticipantActivityUserCountsRequestBuilder getGetSkypeForBusinessParticipantActivityUserCounts(final String period) {
        return new ReportRootGetSkypeForBusinessParticipantActivityUserCountsRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getSkypeForBusinessParticipantActivityUserCounts"), getClient(), null, period);
    }

    public IReportRootGetSkypeForBusinessParticipantActivityMinuteCountsRequestBuilder getGetSkypeForBusinessParticipantActivityMinuteCounts(final String period) {
        return new ReportRootGetSkypeForBusinessParticipantActivityMinuteCountsRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getSkypeForBusinessParticipantActivityMinuteCounts"), getClient(), null, period);
    }

    public IReportRootGetSkypeForBusinessDeviceUsageUserDetailRequestBuilder getGetSkypeForBusinessDeviceUsageUserDetail(final com.microsoft.graph.model.DateOnly date) {
        return new ReportRootGetSkypeForBusinessDeviceUsageUserDetailRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getSkypeForBusinessDeviceUsageUserDetail"), getClient(), null, date);
    }

    public IReportRootGetSkypeForBusinessDeviceUsageUserDetailRequestBuilder getGetSkypeForBusinessDeviceUsageUserDetail(final String period) {
        return new ReportRootGetSkypeForBusinessDeviceUsageUserDetailRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getSkypeForBusinessDeviceUsageUserDetail"), getClient(), null, period);
    }

    public IReportRootGetSkypeForBusinessDeviceUsageDistributionUserCountsRequestBuilder getGetSkypeForBusinessDeviceUsageDistributionUserCounts(final String period) {
        return new ReportRootGetSkypeForBusinessDeviceUsageDistributionUserCountsRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getSkypeForBusinessDeviceUsageDistributionUserCounts"), getClient(), null, period);
    }

    public IReportRootGetSkypeForBusinessDeviceUsageUserCountsRequestBuilder getGetSkypeForBusinessDeviceUsageUserCounts(final String period) {
        return new ReportRootGetSkypeForBusinessDeviceUsageUserCountsRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getSkypeForBusinessDeviceUsageUserCounts"), getClient(), null, period);
    }

    public IReportRootGetYammerActivityUserDetailRequestBuilder getGetYammerActivityUserDetail(final com.microsoft.graph.model.DateOnly date) {
        return new ReportRootGetYammerActivityUserDetailRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getYammerActivityUserDetail"), getClient(), null, date);
    }

    public IReportRootGetYammerActivityUserDetailRequestBuilder getGetYammerActivityUserDetail(final String period) {
        return new ReportRootGetYammerActivityUserDetailRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getYammerActivityUserDetail"), getClient(), null, period);
    }

    public IReportRootGetYammerActivityCountsRequestBuilder getGetYammerActivityCounts(final String period) {
        return new ReportRootGetYammerActivityCountsRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getYammerActivityCounts"), getClient(), null, period);
    }

    public IReportRootGetYammerActivityUserCountsRequestBuilder getGetYammerActivityUserCounts(final String period) {
        return new ReportRootGetYammerActivityUserCountsRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getYammerActivityUserCounts"), getClient(), null, period);
    }

    public IReportRootGetYammerDeviceUsageUserDetailRequestBuilder getGetYammerDeviceUsageUserDetail(final com.microsoft.graph.model.DateOnly date) {
        return new ReportRootGetYammerDeviceUsageUserDetailRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getYammerDeviceUsageUserDetail"), getClient(), null, date);
    }

    public IReportRootGetYammerDeviceUsageUserDetailRequestBuilder getGetYammerDeviceUsageUserDetail(final String period) {
        return new ReportRootGetYammerDeviceUsageUserDetailRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getYammerDeviceUsageUserDetail"), getClient(), null, period);
    }

    public IReportRootGetYammerDeviceUsageDistributionUserCountsRequestBuilder getGetYammerDeviceUsageDistributionUserCounts(final String period) {
        return new ReportRootGetYammerDeviceUsageDistributionUserCountsRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getYammerDeviceUsageDistributionUserCounts"), getClient(), null, period);
    }

    public IReportRootGetYammerDeviceUsageUserCountsRequestBuilder getGetYammerDeviceUsageUserCounts(final String period) {
        return new ReportRootGetYammerDeviceUsageUserCountsRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getYammerDeviceUsageUserCounts"), getClient(), null, period);
    }

    public IReportRootGetYammerGroupsActivityDetailRequestBuilder getGetYammerGroupsActivityDetail(final com.microsoft.graph.model.DateOnly date) {
        return new ReportRootGetYammerGroupsActivityDetailRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getYammerGroupsActivityDetail"), getClient(), null, date);
    }

    public IReportRootGetYammerGroupsActivityDetailRequestBuilder getGetYammerGroupsActivityDetail(final String period) {
        return new ReportRootGetYammerGroupsActivityDetailRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getYammerGroupsActivityDetail"), getClient(), null, period);
    }

    public IReportRootGetYammerGroupsActivityGroupCountsRequestBuilder getGetYammerGroupsActivityGroupCounts(final String period) {
        return new ReportRootGetYammerGroupsActivityGroupCountsRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getYammerGroupsActivityGroupCounts"), getClient(), null, period);
    }

    public IReportRootGetYammerGroupsActivityCountsRequestBuilder getGetYammerGroupsActivityCounts(final String period) {
        return new ReportRootGetYammerGroupsActivityCountsRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getYammerGroupsActivityCounts"), getClient(), null, period);
    }

    public IReportRootGetTeamsUserActivityUserDetailRequestBuilder getGetTeamsUserActivityUserDetail(final com.microsoft.graph.model.DateOnly date) {
        return new ReportRootGetTeamsUserActivityUserDetailRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getTeamsUserActivityUserDetail"), getClient(), null, date);
    }

    public IReportRootGetTeamsUserActivityUserDetailRequestBuilder getGetTeamsUserActivityUserDetail(final String period) {
        return new ReportRootGetTeamsUserActivityUserDetailRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getTeamsUserActivityUserDetail"), getClient(), null, period);
    }

    public IReportRootGetTeamsUserActivityCountsRequestBuilder getGetTeamsUserActivityCounts(final String period) {
        return new ReportRootGetTeamsUserActivityCountsRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getTeamsUserActivityCounts"), getClient(), null, period);
    }

    public IReportRootGetTeamsUserActivityUserCountsRequestBuilder getGetTeamsUserActivityUserCounts(final String period) {
        return new ReportRootGetTeamsUserActivityUserCountsRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getTeamsUserActivityUserCounts"), getClient(), null, period);
    }

    public IReportRootGetTeamsDeviceUsageUserDetailRequestBuilder getGetTeamsDeviceUsageUserDetail(final com.microsoft.graph.model.DateOnly date) {
        return new ReportRootGetTeamsDeviceUsageUserDetailRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getTeamsDeviceUsageUserDetail"), getClient(), null, date);
    }

    public IReportRootGetTeamsDeviceUsageUserDetailRequestBuilder getGetTeamsDeviceUsageUserDetail(final String period) {
        return new ReportRootGetTeamsDeviceUsageUserDetailRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getTeamsDeviceUsageUserDetail"), getClient(), null, period);
    }

    public IReportRootGetTeamsDeviceUsageUserCountsRequestBuilder getGetTeamsDeviceUsageUserCounts(final String period) {
        return new ReportRootGetTeamsDeviceUsageUserCountsRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getTeamsDeviceUsageUserCounts"), getClient(), null, period);
    }

    public IReportRootGetTeamsDeviceUsageDistributionUserCountsRequestBuilder getGetTeamsDeviceUsageDistributionUserCounts(final String period) {
        return new ReportRootGetTeamsDeviceUsageDistributionUserCountsRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getTeamsDeviceUsageDistributionUserCounts"), getClient(), null, period);
    }
}
