// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Outlook User Request.
 */
public class BaseOutlookUserRequest extends BaseRequest implements IBaseOutlookUserRequest {

    /**
     * The request for the OutlookUser
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     * @param responseClass The class of the reponse
     */
    public BaseOutlookUserRequest(final String requestUrl,
            final IBaseClient client,
            final java.util.List<Option> requestOptions,
            final Class responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * Gets the OutlookUser from the service
     * @param callback The callback to be called after success or failure.
     */
    public void get(final ICallback<OutlookUser> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the OutlookUser from the service
     * @return The OutlookUser from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public OutlookUser get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    public void delete(final ICallback<Void> callback) {{
        send(HttpMethod.DELETE, callback, null);
    }}

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {{
        send(HttpMethod.DELETE, null);
    }}

    /**
     * Patches this OutlookUser with a source
     * @param sourceOutlookUser The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    public void patch(final OutlookUser sourceOutlookUser, final ICallback<OutlookUser> callback) {
        send(HttpMethod.PATCH, callback, sourceOutlookUser);
    }

    /**
     * Patches this OutlookUser with a source
     * @param sourceOutlookUser The source object with updates
     * @return The updated OutlookUser
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public OutlookUser patch(final OutlookUser sourceOutlookUser) throws ClientException {
        return send(HttpMethod.PATCH, sourceOutlookUser);
    }

    /**
     * Creates a OutlookUser with a new object
     * @param newOutlookUser The new object to create
     * @param callback The callback to be called after success or failure.
     */
    public void post(final OutlookUser newOutlookUser, final ICallback<OutlookUser> callback) {
        send(HttpMethod.POST, callback, newOutlookUser);
    }

    /**
     * Creates a OutlookUser with a new object
     * @param newOutlookUser The new object to create
     * @return The created OutlookUser
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public OutlookUser post(final OutlookUser newOutlookUser) throws ClientException {
        return send(HttpMethod.POST, newOutlookUser);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
     public IOutlookUserRequest select(final String value) {
         getQueryOptions().add(new QueryOption("$select", value));
         return (OutlookUserRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
     public IOutlookUserRequest expand(final String value) {
         getQueryOptions().add(new QueryOption("$expand", value));
         return (OutlookUserRequest)this;
     }

}

