// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Onenote Section Request Builder.
 */
public class BaseOnenoteSectionRequestBuilder extends BaseRequestBuilder implements IBaseOnenoteSectionRequestBuilder {

    /**
     * The request builder for the OnenoteSection
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseOnenoteSectionRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     */
    public IOnenoteSectionRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     */
    public IOnenoteSectionRequest buildRequest(final java.util.List<Option> requestOptions) {
        return new OnenoteSectionRequest(getRequestUrl(), getClient(), requestOptions);
    }


    /**
     * Gets the request builder for Notebook.
     */
    public INotebookRequestBuilder getParentNotebook() {
        return new NotebookRequestBuilder(getRequestUrlWithAdditionalSegment("parentNotebook"), getClient(), null);
    }

    /**
     * Gets the request builder for SectionGroup.
     */
    public ISectionGroupRequestBuilder getParentSectionGroup() {
        return new SectionGroupRequestBuilder(getRequestUrlWithAdditionalSegment("parentSectionGroup"), getClient(), null);
    }
    public IOnenotePageCollectionRequestBuilder getPages() {
        return new OnenotePageCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("pages"), getClient(), null);
    }

    public IOnenotePageRequestBuilder getPages(final String id) {
        return new OnenotePageRequestBuilder(getRequestUrlWithAdditionalSegment("pages") + "/" + id, getClient(), null);
    }

    public IOnenoteSectionCopyToNotebookRequestBuilder getCopyToNotebook(final String id, final String groupId, final String renameAs, final String siteCollectionId, final String siteId) {
        return new OnenoteSectionCopyToNotebookRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.copyToNotebook"), getClient(), null, id, groupId, renameAs, siteCollectionId, siteId);
    }

    public IOnenoteSectionCopyToSectionGroupRequestBuilder getCopyToSectionGroup(final String id, final String groupId, final String renameAs, final String siteCollectionId, final String siteId) {
        return new OnenoteSectionCopyToSectionGroupRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.copyToSectionGroup"), getClient(), null, id, groupId, renameAs, siteCollectionId, siteId);
    }
}
