// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

// **NOTE** This file was generated by a tool and any changes will be overwritten.
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Onenote Resource Collection Request.
 */
public class BaseOnenoteResourceCollectionRequest extends BaseCollectionRequest<BaseOnenoteResourceCollectionResponse, IOnenoteResourceCollectionPage> implements IBaseOnenoteResourceCollectionRequest {

    /**
     * The request builder for this collection of OnenoteResource
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseOnenoteResourceCollectionRequest(final String requestUrl, IBaseClient client, final java.util.List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseOnenoteResourceCollectionResponse.class, IOnenoteResourceCollectionPage.class);
    }

    public void get(final ICallback<IOnenoteResourceCollectionPage> callback) {
        final IExecutors executors = getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable() {
           @Override
           public void run() {
                try {
                    executors.performOnForeground(get(), callback);
                } catch (final ClientException e) {
                    executors.performOnForeground(e, callback);
                }
           }
        });
    }

    public IOnenoteResourceCollectionPage get() throws ClientException {
        final BaseOnenoteResourceCollectionResponse response = send();
        return buildFromResponse(response);
    }

    public void post(final OnenoteResource newOnenoteResource, final ICallback<OnenoteResource> callback) {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        new OnenoteResourceRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newOnenoteResource, callback);
    }

    public OnenoteResource post(final OnenoteResource newOnenoteResource) throws ClientException {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        return new OnenoteResourceRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newOnenoteResource);
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    public IOnenoteResourceCollectionRequest expand(final String value) {
        addQueryOption(new QueryOption("$expand", value));
        return (OnenoteResourceCollectionRequest)this;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    public IOnenoteResourceCollectionRequest select(final String value) {
        addQueryOption(new QueryOption("$select", value));
        return (OnenoteResourceCollectionRequest)this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value The max number of items to return
     * @return The updated request
     */
    public IOnenoteResourceCollectionRequest top(final int value) {
        addQueryOption(new QueryOption("$top", value + ""));
        return (OnenoteResourceCollectionRequest)this;
    }

    public IOnenoteResourceCollectionPage buildFromResponse(final BaseOnenoteResourceCollectionResponse response) {
        final IOnenoteResourceCollectionRequestBuilder builder;
        if (response.nextLink != null) {
            builder = new OnenoteResourceCollectionRequestBuilder(response.nextLink, getBaseRequest().getClient(), /* options */ null);
        } else {
            builder = null;
        }
        final OnenoteResourceCollectionPage page = new OnenoteResourceCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}
