// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Education User Request.
 */
public class BaseEducationUserRequest extends BaseRequest implements IBaseEducationUserRequest {

    /**
     * The request for the EducationUser
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     * @param responseClass The class of the reponse
     */
    public BaseEducationUserRequest(final String requestUrl,
            final IBaseClient client,
            final java.util.List<Option> requestOptions,
            final Class responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * Gets the EducationUser from the service
     * @param callback The callback to be called after success or failure.
     */
    public void get(final ICallback<EducationUser> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the EducationUser from the service
     * @return The EducationUser from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public EducationUser get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    public void delete(final ICallback<Void> callback) {{
        send(HttpMethod.DELETE, callback, null);
    }}

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {{
        send(HttpMethod.DELETE, null);
    }}

    /**
     * Patches this EducationUser with a source
     * @param sourceEducationUser The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    public void patch(final EducationUser sourceEducationUser, final ICallback<EducationUser> callback) {
        send(HttpMethod.PATCH, callback, sourceEducationUser);
    }

    /**
     * Patches this EducationUser with a source
     * @param sourceEducationUser The source object with updates
     * @return The updated EducationUser
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public EducationUser patch(final EducationUser sourceEducationUser) throws ClientException {
        return send(HttpMethod.PATCH, sourceEducationUser);
    }

    /**
     * Creates a EducationUser with a new object
     * @param newEducationUser The new object to create
     * @param callback The callback to be called after success or failure.
     */
    public void post(final EducationUser newEducationUser, final ICallback<EducationUser> callback) {
        send(HttpMethod.POST, callback, newEducationUser);
    }

    /**
     * Creates a EducationUser with a new object
     * @param newEducationUser The new object to create
     * @return The created EducationUser
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public EducationUser post(final EducationUser newEducationUser) throws ClientException {
        return send(HttpMethod.POST, newEducationUser);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
     public IEducationUserRequest select(final String value) {
         getQueryOptions().add(new QueryOption("$select", value));
         return (EducationUserRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
     public IEducationUserRequest expand(final String value) {
         getQueryOptions().add(new QueryOption("$expand", value));
         return (EducationUserRequest)this;
     }

}

