// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Education School Request.
 */
public class BaseEducationSchoolRequest extends BaseRequest implements IBaseEducationSchoolRequest {

    /**
     * The request for the EducationSchool
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     * @param responseClass The class of the reponse
     */
    public BaseEducationSchoolRequest(final String requestUrl,
            final IBaseClient client,
            final java.util.List<Option> requestOptions,
            final Class responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * Gets the EducationSchool from the service
     * @param callback The callback to be called after success or failure.
     */
    public void get(final ICallback<EducationSchool> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the EducationSchool from the service
     * @return The EducationSchool from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public EducationSchool get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    public void delete(final ICallback<Void> callback) {{
        send(HttpMethod.DELETE, callback, null);
    }}

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {{
        send(HttpMethod.DELETE, null);
    }}

    /**
     * Patches this EducationSchool with a source
     * @param sourceEducationSchool The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    public void patch(final EducationSchool sourceEducationSchool, final ICallback<EducationSchool> callback) {
        send(HttpMethod.PATCH, callback, sourceEducationSchool);
    }

    /**
     * Patches this EducationSchool with a source
     * @param sourceEducationSchool The source object with updates
     * @return The updated EducationSchool
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public EducationSchool patch(final EducationSchool sourceEducationSchool) throws ClientException {
        return send(HttpMethod.PATCH, sourceEducationSchool);
    }

    /**
     * Creates a EducationSchool with a new object
     * @param newEducationSchool The new object to create
     * @param callback The callback to be called after success or failure.
     */
    public void post(final EducationSchool newEducationSchool, final ICallback<EducationSchool> callback) {
        send(HttpMethod.POST, callback, newEducationSchool);
    }

    /**
     * Creates a EducationSchool with a new object
     * @param newEducationSchool The new object to create
     * @return The created EducationSchool
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public EducationSchool post(final EducationSchool newEducationSchool) throws ClientException {
        return send(HttpMethod.POST, newEducationSchool);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
     public IEducationSchoolRequest select(final String value) {
         getQueryOptions().add(new QueryOption("$select", value));
         return (EducationSchoolRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
     public IEducationSchoolRequest expand(final String value) {
         getQueryOptions().add(new QueryOption("$expand", value));
         return (EducationSchoolRequest)this;
     }

}

