// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Education School Reference Request.
 */
public class BaseEducationSchoolReferenceRequest extends BaseRequest implements IBaseEducationSchoolReferenceRequest {

    /**
     * The request for the EducationSchool
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseEducationSchoolReferenceRequest(String requestUrl, IBaseClient client, java.util.List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, EducationSchool.class);
    }

    public void delete(final ICallback<EducationSchool> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    public EducationSchool delete() throws ClientException {
       return send(HttpMethod.DELETE, null);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    public IEducationSchoolReferenceRequest select(final String value) {
        getQueryOptions().add(new QueryOption("$select", value));
        return (EducationSchoolReferenceRequest)this;
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    public IEducationSchoolReferenceRequest expand(final String value) {
        getQueryOptions().add(new QueryOption("$expand", value));
        return (EducationSchoolReferenceRequest)this;
    }
    /**
     * Puts the EducationSchool
     *
     * @param srcEducationSchool The EducationSchool reference to PUT
     * @param callback The callback to be called after success or failure
     */
    public void put(EducationSchool srcEducationSchool, final ICallback<EducationSchool> callback) {
        send(HttpMethod.PUT, callback, srcEducationSchool);
    }

    /**
     * Puts the EducationSchool
     *
     * @param srcEducationSchool The EducationSchool reference to PUT
     * @return The EducationSchool
     * @throws ClientException An exception occurs if there was an error while the request was sent
     */
    public EducationSchool put(EducationSchool srcEducationSchool) throws ClientException {
        return send(HttpMethod.PUT, srcEducationSchool);
    }
}
