// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Domain Dns Unavailable Record Request.
 */
public class BaseDomainDnsUnavailableRecordRequest extends BaseRequest implements IBaseDomainDnsUnavailableRecordRequest {

    /**
     * The request for the DomainDnsUnavailableRecord
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     * @param responseClass The class of the reponse
     */
    public BaseDomainDnsUnavailableRecordRequest(final String requestUrl,
            final IBaseClient client,
            final java.util.List<Option> requestOptions,
            final Class responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * Gets the DomainDnsUnavailableRecord from the service
     * @param callback The callback to be called after success or failure.
     */
    public void get(final ICallback<DomainDnsUnavailableRecord> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the DomainDnsUnavailableRecord from the service
     * @return The DomainDnsUnavailableRecord from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public DomainDnsUnavailableRecord get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    public void delete(final ICallback<Void> callback) {{
        send(HttpMethod.DELETE, callback, null);
    }}

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {{
        send(HttpMethod.DELETE, null);
    }}

    /**
     * Patches this DomainDnsUnavailableRecord with a source
     * @param sourceDomainDnsUnavailableRecord The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    public void patch(final DomainDnsUnavailableRecord sourceDomainDnsUnavailableRecord, final ICallback<DomainDnsUnavailableRecord> callback) {
        send(HttpMethod.PATCH, callback, sourceDomainDnsUnavailableRecord);
    }

    /**
     * Patches this DomainDnsUnavailableRecord with a source
     * @param sourceDomainDnsUnavailableRecord The source object with updates
     * @return The updated DomainDnsUnavailableRecord
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public DomainDnsUnavailableRecord patch(final DomainDnsUnavailableRecord sourceDomainDnsUnavailableRecord) throws ClientException {
        return send(HttpMethod.PATCH, sourceDomainDnsUnavailableRecord);
    }

    /**
     * Creates a DomainDnsUnavailableRecord with a new object
     * @param newDomainDnsUnavailableRecord The new object to create
     * @param callback The callback to be called after success or failure.
     */
    public void post(final DomainDnsUnavailableRecord newDomainDnsUnavailableRecord, final ICallback<DomainDnsUnavailableRecord> callback) {
        send(HttpMethod.POST, callback, newDomainDnsUnavailableRecord);
    }

    /**
     * Creates a DomainDnsUnavailableRecord with a new object
     * @param newDomainDnsUnavailableRecord The new object to create
     * @return The created DomainDnsUnavailableRecord
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public DomainDnsUnavailableRecord post(final DomainDnsUnavailableRecord newDomainDnsUnavailableRecord) throws ClientException {
        return send(HttpMethod.POST, newDomainDnsUnavailableRecord);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
     public IDomainDnsUnavailableRecordRequest select(final String value) {
         getQueryOptions().add(new QueryOption("$select", value));
         return (DomainDnsUnavailableRecordRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
     public IDomainDnsUnavailableRecordRequest expand(final String value) {
         getQueryOptions().add(new QueryOption("$expand", value));
         return (DomainDnsUnavailableRecordRequest)this;
     }

}

