// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Domain Dns Cname Record Request.
 */
public class BaseDomainDnsCnameRecordRequest extends BaseRequest implements IBaseDomainDnsCnameRecordRequest {

    /**
     * The request for the DomainDnsCnameRecord
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     * @param responseClass The class of the reponse
     */
    public BaseDomainDnsCnameRecordRequest(final String requestUrl,
            final IBaseClient client,
            final java.util.List<Option> requestOptions,
            final Class responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * Gets the DomainDnsCnameRecord from the service
     * @param callback The callback to be called after success or failure.
     */
    public void get(final ICallback<DomainDnsCnameRecord> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the DomainDnsCnameRecord from the service
     * @return The DomainDnsCnameRecord from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public DomainDnsCnameRecord get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    public void delete(final ICallback<Void> callback) {{
        send(HttpMethod.DELETE, callback, null);
    }}

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {{
        send(HttpMethod.DELETE, null);
    }}

    /**
     * Patches this DomainDnsCnameRecord with a source
     * @param sourceDomainDnsCnameRecord The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    public void patch(final DomainDnsCnameRecord sourceDomainDnsCnameRecord, final ICallback<DomainDnsCnameRecord> callback) {
        send(HttpMethod.PATCH, callback, sourceDomainDnsCnameRecord);
    }

    /**
     * Patches this DomainDnsCnameRecord with a source
     * @param sourceDomainDnsCnameRecord The source object with updates
     * @return The updated DomainDnsCnameRecord
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public DomainDnsCnameRecord patch(final DomainDnsCnameRecord sourceDomainDnsCnameRecord) throws ClientException {
        return send(HttpMethod.PATCH, sourceDomainDnsCnameRecord);
    }

    /**
     * Creates a DomainDnsCnameRecord with a new object
     * @param newDomainDnsCnameRecord The new object to create
     * @param callback The callback to be called after success or failure.
     */
    public void post(final DomainDnsCnameRecord newDomainDnsCnameRecord, final ICallback<DomainDnsCnameRecord> callback) {
        send(HttpMethod.POST, callback, newDomainDnsCnameRecord);
    }

    /**
     * Creates a DomainDnsCnameRecord with a new object
     * @param newDomainDnsCnameRecord The new object to create
     * @return The created DomainDnsCnameRecord
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public DomainDnsCnameRecord post(final DomainDnsCnameRecord newDomainDnsCnameRecord) throws ClientException {
        return send(HttpMethod.POST, newDomainDnsCnameRecord);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
     public IDomainDnsCnameRecordRequest select(final String value) {
         getQueryOptions().add(new QueryOption("$select", value));
         return (DomainDnsCnameRecordRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
     public IDomainDnsCnameRecordRequest expand(final String value) {
         getQueryOptions().add(new QueryOption("$expand", value));
         return (DomainDnsCnameRecordRequest)this;
     }

}

