// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

// **NOTE** This file was generated by a tool and any changes will be overwritten.
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Domain Collection Request.
 */
public class BaseDomainCollectionRequest extends BaseCollectionRequest<BaseDomainCollectionResponse, IDomainCollectionPage> implements IBaseDomainCollectionRequest {

    /**
     * The request builder for this collection of Domain
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseDomainCollectionRequest(final String requestUrl, IBaseClient client, final java.util.List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseDomainCollectionResponse.class, IDomainCollectionPage.class);
    }

    public void get(final ICallback<IDomainCollectionPage> callback) {
        final IExecutors executors = getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable() {
           @Override
           public void run() {
                try {
                    executors.performOnForeground(get(), callback);
                } catch (final ClientException e) {
                    executors.performOnForeground(e, callback);
                }
           }
        });
    }

    public IDomainCollectionPage get() throws ClientException {
        final BaseDomainCollectionResponse response = send();
        return buildFromResponse(response);
    }

    public void post(final Domain newDomain, final ICallback<Domain> callback) {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        new DomainRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newDomain, callback);
    }

    public Domain post(final Domain newDomain) throws ClientException {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        return new DomainRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newDomain);
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    public IDomainCollectionRequest expand(final String value) {
        addQueryOption(new QueryOption("$expand", value));
        return (DomainCollectionRequest)this;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    public IDomainCollectionRequest select(final String value) {
        addQueryOption(new QueryOption("$select", value));
        return (DomainCollectionRequest)this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value The max number of items to return
     * @return The updated request
     */
    public IDomainCollectionRequest top(final int value) {
        addQueryOption(new QueryOption("$top", value + ""));
        return (DomainCollectionRequest)this;
    }

    public IDomainCollectionPage buildFromResponse(final BaseDomainCollectionResponse response) {
        final IDomainCollectionRequestBuilder builder;
        if (response.nextLink != null) {
            builder = new DomainCollectionRequestBuilder(response.nextLink, getBaseRequest().getClient(), /* options */ null);
        } else {
            builder = null;
        }
        final DomainCollectionPage page = new DomainCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}
