// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Directory Object Collection Request Builder.
 */
public class BaseDirectoryObjectCollectionRequestBuilder extends BaseRequestBuilder implements IBaseDirectoryObjectCollectionRequestBuilder {

    /**
     * The request builder for this collection of DirectoryObject
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseDirectoryObjectCollectionRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    public IDirectoryObjectCollectionRequest buildRequest() {
        return buildRequest(getOptions());
    }

    public IDirectoryObjectCollectionRequest buildRequest(final java.util.List<Option> requestOptions) {
        return new DirectoryObjectCollectionRequest(getRequestUrl(), getClient(), requestOptions);
    }

    public IDirectoryObjectRequestBuilder byId(final String id) {
        return new DirectoryObjectRequestBuilder(getRequestUrlWithAdditionalSegment(id), getClient(), getOptions());
    }

    public IDirectoryObjectGetByIdsCollectionRequestBuilder getGetByIds(final java.util.List<String> ids, final java.util.List<String> types) {
        return new DirectoryObjectGetByIdsCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.getByIds"), getClient(), null, ids, types);
    }
}
