// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

// **NOTE** This file was generated by a tool and any changes will be overwritten.
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Content Type Collection Request.
 */
public class BaseContentTypeCollectionRequest extends BaseCollectionRequest<BaseContentTypeCollectionResponse, IContentTypeCollectionPage> implements IBaseContentTypeCollectionRequest {

    /**
     * The request builder for this collection of ContentType
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseContentTypeCollectionRequest(final String requestUrl, IBaseClient client, final java.util.List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseContentTypeCollectionResponse.class, IContentTypeCollectionPage.class);
    }

    public void get(final ICallback<IContentTypeCollectionPage> callback) {
        final IExecutors executors = getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable() {
           @Override
           public void run() {
                try {
                    executors.performOnForeground(get(), callback);
                } catch (final ClientException e) {
                    executors.performOnForeground(e, callback);
                }
           }
        });
    }

    public IContentTypeCollectionPage get() throws ClientException {
        final BaseContentTypeCollectionResponse response = send();
        return buildFromResponse(response);
    }

    public void post(final ContentType newContentType, final ICallback<ContentType> callback) {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        new ContentTypeRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newContentType, callback);
    }

    public ContentType post(final ContentType newContentType) throws ClientException {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        return new ContentTypeRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newContentType);
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    public IContentTypeCollectionRequest expand(final String value) {
        addQueryOption(new QueryOption("$expand", value));
        return (ContentTypeCollectionRequest)this;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    public IContentTypeCollectionRequest select(final String value) {
        addQueryOption(new QueryOption("$select", value));
        return (ContentTypeCollectionRequest)this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value The max number of items to return
     * @return The updated request
     */
    public IContentTypeCollectionRequest top(final int value) {
        addQueryOption(new QueryOption("$top", value + ""));
        return (ContentTypeCollectionRequest)this;
    }

    public IContentTypeCollectionPage buildFromResponse(final BaseContentTypeCollectionResponse response) {
        final IContentTypeCollectionRequestBuilder builder;
        if (response.nextLink != null) {
            builder = new ContentTypeCollectionRequestBuilder(response.nextLink, getBaseRequest().getClient(), /* options */ null);
        } else {
            builder = null;
        }
        final ContentTypeCollectionPage page = new ContentTypeCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}
