// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

// **NOTE** This file was generated by a tool and any changes will be overwritten.
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Column Definition Collection Request.
 */
public class BaseColumnDefinitionCollectionRequest extends BaseCollectionRequest<BaseColumnDefinitionCollectionResponse, IColumnDefinitionCollectionPage> implements IBaseColumnDefinitionCollectionRequest {

    /**
     * The request builder for this collection of ColumnDefinition
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseColumnDefinitionCollectionRequest(final String requestUrl, IBaseClient client, final java.util.List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseColumnDefinitionCollectionResponse.class, IColumnDefinitionCollectionPage.class);
    }

    public void get(final ICallback<IColumnDefinitionCollectionPage> callback) {
        final IExecutors executors = getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable() {
           @Override
           public void run() {
                try {
                    executors.performOnForeground(get(), callback);
                } catch (final ClientException e) {
                    executors.performOnForeground(e, callback);
                }
           }
        });
    }

    public IColumnDefinitionCollectionPage get() throws ClientException {
        final BaseColumnDefinitionCollectionResponse response = send();
        return buildFromResponse(response);
    }

    public void post(final ColumnDefinition newColumnDefinition, final ICallback<ColumnDefinition> callback) {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        new ColumnDefinitionRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newColumnDefinition, callback);
    }

    public ColumnDefinition post(final ColumnDefinition newColumnDefinition) throws ClientException {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        return new ColumnDefinitionRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newColumnDefinition);
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    public IColumnDefinitionCollectionRequest expand(final String value) {
        addQueryOption(new QueryOption("$expand", value));
        return (ColumnDefinitionCollectionRequest)this;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    public IColumnDefinitionCollectionRequest select(final String value) {
        addQueryOption(new QueryOption("$select", value));
        return (ColumnDefinitionCollectionRequest)this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value The max number of items to return
     * @return The updated request
     */
    public IColumnDefinitionCollectionRequest top(final int value) {
        addQueryOption(new QueryOption("$top", value + ""));
        return (ColumnDefinitionCollectionRequest)this;
    }

    public IColumnDefinitionCollectionPage buildFromResponse(final BaseColumnDefinitionCollectionResponse response) {
        final IColumnDefinitionCollectionRequestBuilder builder;
        if (response.nextLink != null) {
            builder = new ColumnDefinitionCollectionRequestBuilder(response.nextLink, getBaseRequest().getClient(), /* options */ null);
        } else {
            builder = null;
        }
        final ColumnDefinitionCollectionPage page = new ColumnDefinitionCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}
