// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Base Item Version Request.
 */
public class BaseBaseItemVersionRequest extends BaseRequest implements IBaseBaseItemVersionRequest {

    /**
     * The request for the BaseItemVersion
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     * @param responseClass The class of the reponse
     */
    public BaseBaseItemVersionRequest(final String requestUrl,
            final IBaseClient client,
            final java.util.List<Option> requestOptions,
            final Class responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * Gets the BaseItemVersion from the service
     * @param callback The callback to be called after success or failure.
     */
    public void getBaseItemVersion(final ICallback<BaseItemVersion> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the BaseItemVersion from the service
     * @return The BaseItemVersion from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public BaseItemVersion getBaseItemVersion() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    public void delete(final ICallback<Void> callback) {{
        send(HttpMethod.DELETE, callback, null);
    }}

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {{
        send(HttpMethod.DELETE, null);
    }}

    /**
     * Patches this BaseItemVersion with a source
     * @param sourceBaseItemVersion The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    public void patch(final BaseItemVersion sourceBaseItemVersion, final ICallback<BaseItemVersion> callback) {
        send(HttpMethod.PATCH, callback, sourceBaseItemVersion);
    }

    /**
     * Patches this BaseItemVersion with a source
     * @param sourceBaseItemVersion The source object with updates
     * @return The updated BaseItemVersion
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public BaseItemVersion patch(final BaseItemVersion sourceBaseItemVersion) throws ClientException {
        return send(HttpMethod.PATCH, sourceBaseItemVersion);
    }

    /**
     * Creates a BaseItemVersion with a new object
     * @param newBaseItemVersion The new object to create
     * @param callback The callback to be called after success or failure.
     */
    public void post(final BaseItemVersion newBaseItemVersion, final ICallback<BaseItemVersion> callback) {
        send(HttpMethod.POST, callback, newBaseItemVersion);
    }

    /**
     * Creates a BaseItemVersion with a new object
     * @param newBaseItemVersion The new object to create
     * @return The created BaseItemVersion
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public BaseItemVersion post(final BaseItemVersion newBaseItemVersion) throws ClientException {
        return send(HttpMethod.POST, newBaseItemVersion);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
     public IBaseItemVersionRequest select(final String value) {
         getQueryOptions().add(new QueryOption("$select", value));
         return (BaseItemVersionRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
     public IBaseItemVersionRequest expand(final String value) {
         getQueryOptions().add(new QueryOption("$expand", value));
         return (BaseItemVersionRequest)this;
     }

}

