// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Administrative Unit Reference Request.
 */
public class BaseAdministrativeUnitReferenceRequest extends BaseRequest implements IBaseAdministrativeUnitReferenceRequest {

    /**
     * The request for the AdministrativeUnit
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseAdministrativeUnitReferenceRequest(String requestUrl, IBaseClient client, java.util.List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, AdministrativeUnit.class);
    }

    public void delete(final ICallback<AdministrativeUnit> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    public AdministrativeUnit delete() throws ClientException {
       return send(HttpMethod.DELETE, null);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    public IAdministrativeUnitReferenceRequest select(final String value) {
        getQueryOptions().add(new QueryOption("$select", value));
        return (AdministrativeUnitReferenceRequest)this;
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    public IAdministrativeUnitReferenceRequest expand(final String value) {
        getQueryOptions().add(new QueryOption("$expand", value));
        return (AdministrativeUnitReferenceRequest)this;
    }
    /**
     * Puts the AdministrativeUnit
     *
     * @param srcAdministrativeUnit The AdministrativeUnit reference to PUT
     * @param callback The callback to be called after success or failure
     */
    public void put(AdministrativeUnit srcAdministrativeUnit, final ICallback<AdministrativeUnit> callback) {
        send(HttpMethod.PUT, callback, srcAdministrativeUnit);
    }

    /**
     * Puts the AdministrativeUnit
     *
     * @param srcAdministrativeUnit The AdministrativeUnit reference to PUT
     * @return The AdministrativeUnit
     * @throws ClientException An exception occurs if there was an error while the request was sent
     */
    public AdministrativeUnit put(AdministrativeUnit srcAdministrativeUnit) throws ClientException {
        return send(HttpMethod.PUT, srcAdministrativeUnit);
    }
}
