/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.extensions.EducationClass;
import com.microsoft.graph.extensions.EducationClassCollectionPage;
import com.microsoft.graph.extensions.EducationClassCollectionRequest;
import com.microsoft.graph.extensions.EducationClassCollectionRequestBuilder;
import com.microsoft.graph.extensions.EducationClassRequestBuilder;
import com.microsoft.graph.extensions.IEducationClassCollectionPage;
import com.microsoft.graph.extensions.IEducationClassCollectionRequest;
import com.microsoft.graph.generated.BaseEducationClassCollectionResponse;
import com.microsoft.graph.generated.IBaseEducationClassCollectionRequest;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import java.util.List;

public class BaseEducationClassCollectionRequest
extends BaseCollectionRequest<BaseEducationClassCollectionResponse, IEducationClassCollectionPage>
implements IBaseEducationClassCollectionRequest {
    public BaseEducationClassCollectionRequest(String requestUrl, IBaseClient client, List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseEducationClassCollectionResponse.class, IEducationClassCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IEducationClassCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseEducationClassCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IEducationClassCollectionPage get() throws ClientException {
        BaseEducationClassCollectionResponse response = (BaseEducationClassCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(EducationClass newEducationClass, ICallback<EducationClass> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new EducationClassRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newEducationClass, callback);
    }

    @Override
    public EducationClass post(EducationClass newEducationClass) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new EducationClassRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newEducationClass);
    }

    @Override
    public IEducationClassCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (EducationClassCollectionRequest)this;
    }

    @Override
    public IEducationClassCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (EducationClassCollectionRequest)this;
    }

    @Override
    public IEducationClassCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (EducationClassCollectionRequest)this;
    }

    public IEducationClassCollectionPage buildFromResponse(BaseEducationClassCollectionResponse response) {
        EducationClassCollectionRequestBuilder builder = response.nextLink != null ? new EducationClassCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        EducationClassCollectionPage page = new EducationClassCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

