/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.extensions.DriveItemInviteBody;
import com.microsoft.graph.extensions.DriveItemInviteCollectionPage;
import com.microsoft.graph.extensions.DriveItemInviteCollectionRequestBuilder;
import com.microsoft.graph.extensions.IDriveItemInviteCollectionPage;
import com.microsoft.graph.extensions.IDriveItemInviteCollectionRequest;
import com.microsoft.graph.generated.BaseDriveItemInviteCollectionResponse;
import com.microsoft.graph.generated.IBaseDriveItemInviteCollectionRequest;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import java.util.List;

public class BaseDriveItemInviteCollectionRequest
extends BaseCollectionRequest<BaseDriveItemInviteCollectionResponse, IDriveItemInviteCollectionPage>
implements IBaseDriveItemInviteCollectionRequest {
    protected final DriveItemInviteBody mBody = new DriveItemInviteBody();

    public BaseDriveItemInviteCollectionRequest(String requestUrl, IBaseClient client, List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseDriveItemInviteCollectionResponse.class, IDriveItemInviteCollectionPage.class);
    }

    @Override
    public void post(final ICallback<IDriveItemInviteCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseDriveItemInviteCollectionRequest.this.post(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IDriveItemInviteCollectionPage post() throws ClientException {
        BaseDriveItemInviteCollectionResponse response = (BaseDriveItemInviteCollectionResponse)this.post(this.mBody);
        return this.buildFromResponse(response);
    }

    public IDriveItemInviteCollectionPage buildFromResponse(BaseDriveItemInviteCollectionResponse response) {
        DriveItemInviteCollectionRequestBuilder builder = response.nextLink != null ? new DriveItemInviteCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null, null, null, null, null, null) : null;
        DriveItemInviteCollectionPage page = new DriveItemInviteCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }

    @Override
    public IDriveItemInviteCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (IDriveItemInviteCollectionRequest)((Object)this);
    }

    @Override
    public IDriveItemInviteCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (IDriveItemInviteCollectionRequest)((Object)this);
    }

    @Override
    public IDriveItemInviteCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (IDriveItemInviteCollectionRequest)((Object)this);
    }
}

