/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.extensions.Device;
import com.microsoft.graph.extensions.DeviceCollectionPage;
import com.microsoft.graph.extensions.DeviceCollectionRequest;
import com.microsoft.graph.extensions.DeviceCollectionRequestBuilder;
import com.microsoft.graph.extensions.DeviceRequestBuilder;
import com.microsoft.graph.extensions.IDeviceCollectionPage;
import com.microsoft.graph.extensions.IDeviceCollectionRequest;
import com.microsoft.graph.generated.BaseDeviceCollectionResponse;
import com.microsoft.graph.generated.IBaseDeviceCollectionRequest;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import java.util.List;

public class BaseDeviceCollectionRequest
extends BaseCollectionRequest<BaseDeviceCollectionResponse, IDeviceCollectionPage>
implements IBaseDeviceCollectionRequest {
    public BaseDeviceCollectionRequest(String requestUrl, IBaseClient client, List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseDeviceCollectionResponse.class, IDeviceCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IDeviceCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseDeviceCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IDeviceCollectionPage get() throws ClientException {
        BaseDeviceCollectionResponse response = (BaseDeviceCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(Device newDevice, ICallback<Device> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new DeviceRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newDevice, callback);
    }

    @Override
    public Device post(Device newDevice) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new DeviceRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newDevice);
    }

    @Override
    public IDeviceCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (DeviceCollectionRequest)this;
    }

    @Override
    public IDeviceCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (DeviceCollectionRequest)this;
    }

    @Override
    public IDeviceCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (DeviceCollectionRequest)this;
    }

    public IDeviceCollectionPage buildFromResponse(BaseDeviceCollectionResponse response) {
        DeviceCollectionRequestBuilder builder = response.nextLink != null ? new DeviceCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        DeviceCollectionPage page = new DeviceCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

