/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.extensions;

import com.microsoft.graph.concurrency.ChunkedUploadResponseHandler;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.GraphErrorCodes;
import com.microsoft.graph.extensions.ChunkedUploadResult;
import com.microsoft.graph.extensions.IGraphServiceClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.http.IHttpRequest;
import com.microsoft.graph.options.Option;
import java.util.List;

public class ChunkedUploadRequest {
    private static final String CONTENT_RANGE_HEADER_NAME = "Content-Range";
    private static final String CONTENT_RANGE_FORMAT = "bytes %1$d-%2$d/%3$d";
    private static final int RETRY_DELAY = 2000;
    private final byte[] mData;
    private final BaseRequest mBaseRequest;
    private final int mMaxRetry;
    private int mRetryCount;

    public ChunkedUploadRequest(String requestUrl, IGraphServiceClient client, List<Option> options, byte[] chunk, int chunkSize, int maxRetry, int beginIndex, int totalLength) {
        this.mData = new byte[chunkSize];
        System.arraycopy(chunk, 0, this.mData, 0, chunkSize);
        this.mRetryCount = 0;
        this.mMaxRetry = maxRetry;
        this.mBaseRequest = new BaseRequest(requestUrl, client, options, ChunkedUploadResult.class){};
        this.mBaseRequest.setHttpMethod(HttpMethod.PUT);
        this.mBaseRequest.addHeader(CONTENT_RANGE_HEADER_NAME, String.format(CONTENT_RANGE_FORMAT, beginIndex, beginIndex + chunkSize - 1, totalLength));
    }

    public <UploadType> ChunkedUploadResult upload(ChunkedUploadResponseHandler<UploadType> responseHandler) {
        while (this.mRetryCount < this.mMaxRetry) {
            try {
                Thread.sleep(2000 * this.mRetryCount * this.mRetryCount);
            }
            catch (InterruptedException e) {
                this.mBaseRequest.getClient().getLogger().logError("Exception while waiting upload file retry", e);
            }
            ChunkedUploadResult result = null;
            try {
                result = this.mBaseRequest.getClient().getHttpProvider().send((IHttpRequest)this.mBaseRequest, ChunkedUploadResult.class, this.mData, responseHandler);
            }
            catch (ClientException e) {
                this.mBaseRequest.getClient().getLogger().logDebug("Request failed with, retry if necessary.");
            }
            if (result != null && result.chunkCompleted()) {
                return result;
            }
            ++this.mRetryCount;
        }
        return new ChunkedUploadResult(new ClientException("Upload session failed to many times.", null, GraphErrorCodes.UploadSessionIncomplete));
    }
}

