// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Base Workbook Chart Gridlines Format Request.
 */
public interface IBaseWorkbookChartGridlinesFormatRequest extends IHttpRequest {

    /**
     * Gets the WorkbookChartGridlinesFormat from the service
     * @param callback The callback to be called after success or failure.
     */
    void get(final ICallback<WorkbookChartGridlinesFormat> callback);

    /**
     * Gets the WorkbookChartGridlinesFormat from the service
     * @return The WorkbookChartGridlinesFormat from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    WorkbookChartGridlinesFormat get() throws ClientException;

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    void delete(final ICallback<Void> callback);

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this WorkbookChartGridlinesFormat with a source
     * @param sourceWorkbookChartGridlinesFormat The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    void patch(final WorkbookChartGridlinesFormat sourceWorkbookChartGridlinesFormat, final ICallback<WorkbookChartGridlinesFormat> callback);

    /**
     * Patches this WorkbookChartGridlinesFormat with a source
     * @param sourceWorkbookChartGridlinesFormat The source object with updates
     * @return The updated WorkbookChartGridlinesFormat
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    WorkbookChartGridlinesFormat patch(final WorkbookChartGridlinesFormat sourceWorkbookChartGridlinesFormat) throws ClientException;

    /**
     * Posts a WorkbookChartGridlinesFormat with a new object
     * @param newWorkbookChartGridlinesFormat The new object to create
     * @param callback The callback to be called after success or failure.
     */
    void post(final WorkbookChartGridlinesFormat newWorkbookChartGridlinesFormat, final ICallback<WorkbookChartGridlinesFormat> callback);

    /**
     * Posts a WorkbookChartGridlinesFormat with a new object
     * @param newWorkbookChartGridlinesFormat The new object to create
     * @return The created WorkbookChartGridlinesFormat
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    WorkbookChartGridlinesFormat post(final WorkbookChartGridlinesFormat newWorkbookChartGridlinesFormat) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    IBaseWorkbookChartGridlinesFormatRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    IBaseWorkbookChartGridlinesFormatRequest expand(final String value);

}

