// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;
// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Workbook Chart Image Request Builder.
 */
public class BaseWorkbookChartImageRequestBuilder extends BaseFunctionRequestBuilder {

    /**
     * The request builder for this WorkbookChartImage
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseWorkbookChartImageRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }
    /**
     * The request builder for this WorkbookChartImage
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseWorkbookChartImageRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<Option> requestOptions, final Integer width) {
        super(requestUrl, client, requestOptions);
        mFunctionOptions.add(new FunctionOption("width", width));
    }
    /**
     * The request builder for this WorkbookChartImage
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseWorkbookChartImageRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<Option> requestOptions, final Integer width, final Integer height) {
        super(requestUrl, client, requestOptions);
        mFunctionOptions.add(new FunctionOption("width", width));
        mFunctionOptions.add(new FunctionOption("height", height));
    }
    /**
     * The request builder for this WorkbookChartImage
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseWorkbookChartImageRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<Option> requestOptions, final Integer width, final Integer height, final String fittingMode) {
        super(requestUrl, client, requestOptions);
        mFunctionOptions.add(new FunctionOption("width", width));
        mFunctionOptions.add(new FunctionOption("height", height));
        mFunctionOptions.add(new FunctionOption("fittingMode", fittingMode));
    }

    /**
     * Creates the IWorkbookChartImageRequest
     *
     * @return The IWorkbookChartImageRequest instance
     */
    public IWorkbookChartImageRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the IWorkbookChartImageRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return The IWorkbookChartImageRequest instance
     */
    public IWorkbookChartImageRequest buildRequest(final java.util.List<Option> requestOptions) {
        WorkbookChartImageRequest request = new WorkbookChartImageRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

      for (FunctionOption option : mFunctionOptions) {
            request.addFunctionOption(option);
      }

        return request;
    }
}
