// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;
// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Onenote Section Copy To Notebook Request Builder.
 */
public class BaseOnenoteSectionCopyToNotebookRequestBuilder extends BaseActionRequestBuilder {

    /**
     * The request builder for this OnenoteSectionCopyToNotebook
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseOnenoteSectionCopyToNotebookRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<Option> requestOptions, final String id, final String groupId, final String renameAs) {
        super(requestUrl, client, requestOptions);
        mBodyParams.put("id", id);
        mBodyParams.put("groupId", groupId);
        mBodyParams.put("renameAs", renameAs);
    }

    /**
     * Creates the IOnenoteSectionCopyToNotebookRequest
     *
     * @return The IOnenoteSectionCopyToNotebookRequest instance
     */
    public IOnenoteSectionCopyToNotebookRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the IOnenoteSectionCopyToNotebookRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return The IOnenoteSectionCopyToNotebookRequest instance
     */
    public IOnenoteSectionCopyToNotebookRequest buildRequest(final java.util.List<Option> requestOptions) {
        OnenoteSectionCopyToNotebookRequest request = new OnenoteSectionCopyToNotebookRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        if (hasParameter("id")) {
            request.mBody.id = getParameter("id");
        }

        if (hasParameter("groupId")) {
            request.mBody.groupId = getParameter("groupId");
        }

        if (hasParameter("renameAs")) {
            request.mBody.renameAs = getParameter("renameAs");
        }

        return request;
    }
}
