// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

import com.google.gson.JsonObject;
import com.google.gson.JsonElement;
import com.google.gson.annotations.*;
import java.util.HashMap;
import java.util.Map;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Invitation.
 */
public class BaseInvitation extends Entity implements IJsonBackedObject {


    /**
     * The Invited User Display Name.
     * 
     */
    @SerializedName("invitedUserDisplayName")
    @Expose
    public String invitedUserDisplayName;

    /**
     * The Invited User Type.
     * 
     */
    @SerializedName("invitedUserType")
    @Expose
    public String invitedUserType;

    /**
     * The Invited User Email Address.
     * 
     */
    @SerializedName("invitedUserEmailAddress")
    @Expose
    public String invitedUserEmailAddress;

    /**
     * The Invited User Message Info.
     * 
     */
    @SerializedName("invitedUserMessageInfo")
    @Expose
    public InvitedUserMessageInfo invitedUserMessageInfo;

    /**
     * The Send Invitation Message.
     * 
     */
    @SerializedName("sendInvitationMessage")
    @Expose
    public Boolean sendInvitationMessage;

    /**
     * The Invite Redirect Url.
     * 
     */
    @SerializedName("inviteRedirectUrl")
    @Expose
    public String inviteRedirectUrl;

    /**
     * The Invite Redeem Url.
     * 
     */
    @SerializedName("inviteRedeemUrl")
    @Expose
    public String inviteRedeemUrl;

    /**
     * The Status.
     * 
     */
    @SerializedName("status")
    @Expose
    public String status;

    /**
     * The Invited User.
     * 
     */
    @SerializedName("invitedUser")
    @Expose
    public User invitedUser;


    /**
     * The raw representation of this class
     */
    private transient JsonObject mRawObject;

    /**
     * The serializer
     */
    private transient ISerializer mSerializer;

    /**
     * Gets the raw representation of this class
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return mRawObject;
    }

    /**
     * Gets serializer
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return mSerializer;
    }

    /**
     * Sets the raw json object
     *
     * @param serializer The serializer
     * @param json The json object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        mSerializer = serializer;
        mRawObject = json;

    }
}
