// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Group Lifecycle Policy Collection Request Builder.
 */
public class BaseGroupLifecyclePolicyCollectionRequestBuilder extends BaseRequestBuilder implements IBaseGroupLifecyclePolicyCollectionRequestBuilder {

    /**
     * The request builder for this collection of GroupLifecyclePolicy
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseGroupLifecyclePolicyCollectionRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    public IGroupLifecyclePolicyCollectionRequest buildRequest() {
        return buildRequest(getOptions());
    }

    public IGroupLifecyclePolicyCollectionRequest buildRequest(final java.util.List<Option> requestOptions) {
        return new GroupLifecyclePolicyCollectionRequest(getRequestUrl(), getClient(), requestOptions);
    }

    public IGroupLifecyclePolicyRequestBuilder byId(final String id) {
        return new GroupLifecyclePolicyRequestBuilder(getRequestUrlWithAdditionalSegment(id), getClient(), getOptions());
    }
}
