// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

// **NOTE** This file was generated by a tool and any changes will be overwritten.
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Education School Collection Request.
 */
public class BaseEducationSchoolCollectionRequest extends BaseCollectionRequest<BaseEducationSchoolCollectionResponse, IEducationSchoolCollectionPage> implements IBaseEducationSchoolCollectionRequest {

    /**
     * The request builder for this collection of EducationSchool
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseEducationSchoolCollectionRequest(final String requestUrl, IBaseClient client, final java.util.List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseEducationSchoolCollectionResponse.class, IEducationSchoolCollectionPage.class);
    }

    public void get(final ICallback<IEducationSchoolCollectionPage> callback) {
        final IExecutors executors = getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable() {
           @Override
           public void run() {
                try {
                    executors.performOnForeground(get(), callback);
                } catch (final ClientException e) {
                    executors.performOnForeground(e, callback);
                }
           }
        });
    }

    public IEducationSchoolCollectionPage get() throws ClientException {
        final BaseEducationSchoolCollectionResponse response = send();
        return buildFromResponse(response);
    }

    public void post(final EducationSchool newEducationSchool, final ICallback<EducationSchool> callback) {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        new EducationSchoolRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newEducationSchool, callback);
    }

    public EducationSchool post(final EducationSchool newEducationSchool) throws ClientException {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        return new EducationSchoolRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newEducationSchool);
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    public IEducationSchoolCollectionRequest expand(final String value) {
        addQueryOption(new QueryOption("$expand", value));
        return (EducationSchoolCollectionRequest)this;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    public IEducationSchoolCollectionRequest select(final String value) {
        addQueryOption(new QueryOption("$select", value));
        return (EducationSchoolCollectionRequest)this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value The max number of items to return
     * @return The updated request
     */
    public IEducationSchoolCollectionRequest top(final int value) {
        addQueryOption(new QueryOption("$top", value + ""));
        return (EducationSchoolCollectionRequest)this;
    }

    public IEducationSchoolCollectionPage buildFromResponse(final BaseEducationSchoolCollectionResponse response) {
        final IEducationSchoolCollectionRequestBuilder builder;
        if (response.nextLink != null) {
            builder = new EducationSchoolCollectionRequestBuilder(response.nextLink, getBaseRequest().getClient(), /* options */ null);
        } else {
            builder = null;
        }
        final EducationSchoolCollectionPage page = new EducationSchoolCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}
