// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Education Class Renew Request.
 */
public class BaseEducationClassRenewRequest extends BaseRequest implements IBaseEducationClassRenewRequest {

    /**
     * The request for this EducationClassRenew
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseEducationClassRenewRequest(final String requestUrl, final IBaseClient client, final java.util.List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, Boolean.class);
    }

    /**
     * Creates the EducationClassRenew
     *
     * @param callback The callback to be called after success or failure.
     */
    public void post(final ICallback<Boolean> callback) {
        send(HttpMethod.POST, callback, null);
    }

    /**
     * Creates the EducationClassRenew
     *
     * @return The Boolean
     * @throws ClientException An exception occurs if there was an error while the request was sent.
     */
    public Boolean post() throws ClientException {
       return send(HttpMethod.POST, null);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    public IEducationClassRenewRequest select(final String value) {
        getQueryOptions().add(new QueryOption("$select", value));
        return (EducationClassRenewRequest)this;
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    public IEducationClassRenewRequest expand(final String value) {
        getQueryOptions().add(new QueryOption("$expand", value));
        return (EducationClassRenewRequest)this;
    }

}
