/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.serializer;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public final class CalendarSerializer {
    private CalendarSerializer() {
    }

    public static Calendar deserialize(String strVal) throws ParseException {
        String datePattern;
        String modifiedStrVal;
        String zSuffix;
        boolean hasZ;
        boolean bl = hasZ = strVal.indexOf(90) != -1;
        if (hasZ) {
            zSuffix = "Z";
            modifiedStrVal = strVal.replace("Z", "+0000");
        } else {
            zSuffix = "";
            modifiedStrVal = strVal;
        }
        if (modifiedStrVal.contains(".")) {
            String milliseconds = modifiedStrVal.substring(modifiedStrVal.indexOf(".") + 1, modifiedStrVal.indexOf("+"));
            int millisSegmentLength = 3;
            if (milliseconds.length() > 3) {
                milliseconds = milliseconds.substring(0, 3);
                modifiedStrVal = modifiedStrVal.substring(0, modifiedStrVal.indexOf(".") + 1) + milliseconds + modifiedStrVal.substring(modifiedStrVal.indexOf("+"));
            }
            datePattern = "yyyy-MM-dd'T'HH:mm:ss.SSS" + zSuffix;
        } else {
            datePattern = "yyyy-MM-dd'T'HH:mm:ss" + zSuffix;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(datePattern);
        dateFormat.setTimeZone(TimeZone.getDefault());
        Date date = dateFormat.parse(modifiedStrVal);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    public static String serialize(Calendar src) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'.'SSS'Z'", Locale.ROOT);
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dateFormat.format(src.getTime());
    }
}

