/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.model;

import java.text.ParseException;
import java.util.Locale;

public class DateOnly {
    private final int mYear;
    private final int mMonth;
    private final int mDay;

    public static DateOnly parse(String dateStr) throws ParseException {
        String[] dateInfo = dateStr.split("-");
        int expectedLength = 3;
        if (dateInfo.length != 3) {
            throw new ParseException("Expected datestring format 'yyyy-mm-dd' but found: " + dateStr, 0);
        }
        boolean indYear = false;
        boolean indMonth = true;
        int indDay = 2;
        int year = Integer.parseInt(dateInfo[0]);
        int month = Integer.parseInt(dateInfo[1]);
        int day = Integer.parseInt(dateInfo[2]);
        return new DateOnly(year, month, day);
    }

    public DateOnly(int year, int month, int day) {
        this.mYear = year;
        this.mMonth = month;
        this.mDay = day;
    }

    public int getYear() {
        return this.mYear;
    }

    public int getMonth() {
        return this.mMonth;
    }

    public int getDay() {
        return this.mDay;
    }

    public String toString() {
        return String.format(Locale.ROOT, "%04d-%02d-%02d", this.mYear, this.mMonth, this.mDay);
    }
}

